package com.zork.send.kafka.kafka;

import com.zork.send.kafka.model.KafkaConfig;
import lombok.extern.slf4j.Slf4j;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerConfig;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.StringSerializer;

import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;

/**
 * @Author: Prock.Liy
 * @Date： 2021/8/10
 * @Description：
 */
@Slf4j
public class Producer extends Thread {

    private final KafkaProducer<Integer, String> producer;
    private final KafkaConfig kafkaConfig;
    private final List<String> messageList;

    public Producer(List<String> messageList, KafkaConfig kafkaConfig) {
        Properties properties = new Properties();
        properties.put(ProducerConfig.BOOTSTRAP_SERVERS_CONFIG, kafkaConfig.getServers());
        properties.put(ProducerConfig.CLIENT_ID_CONFIG, "producer");
        properties.put("auto.commit.interval.ms", "1000");
        properties.put("session.timeout.ms", "30000");
        properties.put("max.request.size", "104857600");
        properties.put(ProducerConfig.KEY_SERIALIZER_CLASS_CONFIG, IntegerSerializer.class.getName());
        properties.put(ProducerConfig.VALUE_SERIALIZER_CLASS_CONFIG, StringSerializer.class.getName());

        producer = new KafkaProducer<Integer, String>(properties);
        this.messageList = messageList;
        this.kafkaConfig = kafkaConfig;
    }

    @Override
    public void run() {
        if (kafkaConfig.getMessageArraySize() != messageList.size()) {
            log.error("生成message信息组错误,message大小: {}; 配置文件发送信息次数为: {}", messageList.size(), kafkaConfig.getMessageArraySize());
        }
        messageList.forEach(message -> {
            try {
                producer.send(new ProducerRecord<>(kafkaConfig.getTopic(), 3, message), ((recordMetadata, e) -> {
                    System.out.println(recordMetadata.offset() + "->" + recordMetadata.partition());
                    log.info("【本次发送消息至Kafka ,{} Size大小:  {}】", message.getBytes().length, message.getBytes().length / (1024 * 1024) + "M");
                }));
                TimeUnit.SECONDS.sleep(2);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
        });
    }

}
