package com.zork.common.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.*;
import org.springframework.web.client.RestTemplate;

import static com.zork.common.utils.DateUtil.yearMonthDayPoint;

/**
 * RestTemplate 远程调用公共类
 *
 * @author Prock.Liy
 */
@Slf4j
public class RestTemplateUtil {

    private static final RestTemplate restTemplate = new RestTemplate();

    // --------------------------------------- GET -------------------------------------------------------------

    /**
     * 返回jsonarray
     * @param url
     * @return
     */
    public static JSONArray getJSONArray(String url) {
        JSONArray jsonArray = new JSONArray();
        try {
            jsonArray = restTemplate.exchange(url, HttpMethod.GET,null, JSONArray.class).getBody();
        }catch (Exception e){
            log.error("getJSONArray RestTemplate Error:{}",e.getMessage());
        }
        return jsonArray;
    }

    // --------------------------------------- POST -------------------------------------------------------------

    /**
     * postJSONObject
     * @param url
     * @return
     */
    public static JSONObject postJSONObject(String url,JSONObject param) {
        JSONObject jsonObject = new JSONObject();
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            HttpEntity entity = new HttpEntity<>(param, headers);
            ResponseEntity<JSONObject> result = restTemplate.exchange(String.format(url, yearMonthDayPoint()), HttpMethod.POST, entity, JSONObject.class);
            jsonObject = result.getBody();
        }catch (Exception e){
            log.error("postJSONObject RestTemplate Error:{}",e.getMessage());
        }
        return jsonObject;
    }
}
