package com.zork.common.handler;

import lombok.extern.slf4j.Slf4j;

import java.util.function.Consumer;

/**
 * @Author: Prock.Liy
 * @Date： 2021/6/2
 * @Description：
 */
@Slf4j
public class ConsumerWrapperHandler {

    /**
     * 处理stream流中异常
     * @param throwingConsumer
     * @param <T>
     * @return
     */
    public static <T> Consumer<T> throwingConsumerWrapper(
            com.zork.common.handler.ThrowingConsumer<T, Exception> throwingConsumer) {

        return i -> {
            try {
                throwingConsumer.accept(i);
            } catch (Exception ex) {
                ex.printStackTrace();
                log.error("\n Stream Exception: -> {}", ex.getMessage());
            }
        };
    }

}
