/*
 * Decompiled with CFR 0.152.
 */
package com.zork.common.utils;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletResponse;
import net.sourceforge.pinyin4j.PinyinHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZorkUtil {
    private static final Logger log = LoggerFactory.getLogger(ZorkUtil.class);

    public static String getPinYinHeadChar(String str) {
        String convert = "";
        for (int j = 0; j < str.length(); ++j) {
            char word = str.charAt(j);
            String[] pinyinArray = PinyinHelper.toHanyuPinyinStringArray((char)word);
            convert = pinyinArray != null ? convert + pinyinArray[0].charAt(0) : convert + word;
        }
        return convert;
    }

    public static String getLocalIp() {
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            ArrayList<String> list = new ArrayList<String>();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface networkInterface = networkInterfaces.nextElement();
                if (!networkInterface.isUp() || networkInterface.isVirtual() || networkInterface.isLoopback()) continue;
                Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
                while (inetAddresses.hasMoreElements()) {
                    InetAddress inetAddress = inetAddresses.nextElement();
                    if (!(inetAddress instanceof Inet4Address)) continue;
                    String hostAddress = inetAddress.getHostAddress();
                    String hostName = inetAddress.getCanonicalHostName();
                    list.add(hostAddress);
                }
            }
            return (String)list.get(0);
        }
        catch (SocketException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void makeResponse(HttpServletResponse response, String contentType, int status, Object value) throws IOException {
        response.setContentType(contentType);
        response.setStatus(status);
        response.getOutputStream().write(JSONObject.toJSONString((Object)value).getBytes());
    }

    public static boolean match(String regex, String value) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(value);
        return matcher.matches();
    }

    public static Map<String, Object> getDataTable(IPage<?> pageInfo) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("rows", pageInfo.getRecords());
        data.put("total", pageInfo.getTotal());
        return data;
    }
}

