/*
 * Decompiled with CFR 0.152.
 */
package com.zork.common.utils;

import com.zork.common.dto.ExecuteResultDTO;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DriverManager;
import org.apache.ibatis.io.Resources;
import org.apache.ibatis.jdbc.ScriptRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlFileExecuteUtil {
    private static final Logger log = LoggerFactory.getLogger(SqlFileExecuteUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExecuteResultDTO executeSql(String taskStepId, String url, String userName, String userPassword, String filePath) throws IOException {
        ExecuteResultDTO executeResult = new ExecuteResultDTO();
        executeResult.setTaskStepId(taskStepId);
        StringWriter succeedWriter = new StringWriter();
        PrintWriter succeedOut = new PrintWriter(succeedWriter);
        StringWriter errorWriter = new StringWriter();
        PrintWriter errorOut = new PrintWriter(errorWriter);
        Connection conn = null;
        try {
            conn = SqlFileExecuteUtil.getMySqlConnection(url, userName, userPassword);
        }
        catch (Exception e) {
            e.printStackTrace();
            executeResult.setStatus(1);
            executeResult.setLog(e.getStackTrace().toString());
            e.printStackTrace();
            log.error("ExecuteSqlException: " + e.getMessage());
            try {
                conn.close();
            }
            catch (Exception ee) {
                ee.printStackTrace();
                log.error("ExecuteSqlException: " + url + "\u5173\u95ed\u8fde\u63a5\u9519\u8bef!");
            }
            return executeResult;
        }
        ScriptRunner runner = new ScriptRunner(conn);
        Resources.setCharset((Charset)StandardCharsets.UTF_8);
        runner.setAutoCommit(false);
        runner.setSendFullScript(true);
        runner.setLogWriter(succeedOut);
        runner.setErrorLogWriter(errorOut);
        runner.setStopOnError(true);
        FileReader read = new FileReader(filePath);
        try {
            runner.runScript((Reader)read);
        }
        catch (Exception e) {
            e.printStackTrace();
            executeResult.setStatus(1);
            executeResult.setLog(errorWriter.toString());
            log.error("ExecuteSqlException: " + e.getMessage());
            ExecuteResultDTO executeResultDTO = executeResult;
            return executeResultDTO;
        }
        finally {
            try {
                runner.closeConnection();
                conn.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error("ExecuteSqlException:   " + url + "\u5173\u95ed\u8fde\u63a5\u9519\u8bef!");
            }
        }
        executeResult.setSucceed(true);
        executeResult.setLog(succeedWriter.getBuffer().toString());
        executeResult.setStatus(0);
        return executeResult;
    }

    public static Connection getMySqlConnection(String url, String userName, String userPassword) throws Exception {
        Class.forName("com.microsoft.sqlserver.jdbc.SQLServerDriver");
        return DriverManager.getConnection(url, userName, userPassword);
    }
}

