/*
 * Decompiled with CFR 0.152.
 */
package com.zork.common.utils;

import com.opencsv.CSVReader;
import com.opencsv.exceptions.CsvValidationException;
import com.zork.common.dto.KeyValueDTO;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtil {
    private static final Logger log = LoggerFactory.getLogger(FileUtil.class);

    public static void appendMethodB(String fileName, String content, boolean isAppend) {
        try {
            FileWriter writer = new FileWriter(fileName, isAppend);
            isAppend = true;
            if (true) {
                writer.write(content + "\n");
            } else {
                writer.write(content);
            }
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            log.error("\n \u6587\u4ef6\u5199\u5165\u5f02\u5e38: -> {}", (Object)e.getMessage());
        }
    }

    public static Integer readerFileRow(String filePath) {
        int linenumber = 0;
        try {
            File file = new File(filePath);
            if (file.exists()) {
                FileReader fr = new FileReader(file);
                LineNumberReader lnr = new LineNumberReader(fr);
                while (lnr.readLine() != null) {
                    ++linenumber;
                }
                lnr.close();
            } else {
                log.error("File does not exists!");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            log.error("readerFileRow Exception!");
        }
        return linenumber;
    }

    public static KeyValueDTO readCsv(String csvFile) {
        KeyValueDTO keyValueDTO = new KeyValueDTO();
        CSVReader reader = null;
        try {
            CharSequence[] line;
            reader = new CSVReader((Reader)new FileReader(csvFile));
            String key = "";
            int index = 0;
            ArrayList<String> valueList = new ArrayList<String>();
            while ((line = reader.readNext()) != null) {
                if (index == 0) {
                    key = StringUtils.substringAfter((String)String.join((CharSequence)"; ", line), (String)";").replaceAll("\"", "").trim();
                    keyValueDTO.setKeyList(Arrays.asList(key.split(";")));
                }
                if (index != 0) {
                    valueList.add(String.join((CharSequence)";", line));
                }
                ++index;
            }
            keyValueDTO.setValueList(valueList);
        }
        catch (CsvValidationException | IOException e) {
            log.error("\u89e3\u6790\u6587\u4ef6\u6570\u636e\u51fa\u9519,\u672c\u6b21\u5bfc\u5165InfluxDB\u4efb\u52a1\u9000\u51fa!\uff0cError:\u3010\u001b[31m{}\u001b[0m\u3011", (Object)e.getMessage());
        }
        return keyValueDTO;
    }

    public static String readFile(String filePath) {
        StringBuffer buffer = new StringBuffer();
        try (BufferedReader br = Files.newBufferedReader(Paths.get(filePath, new String[0]));){
            String line;
            while ((line = br.readLine()) != null) {
                buffer.append(line + "\n");
            }
        }
        catch (Exception e) {
            log.error("readFile Error:{} , filePath:{}", (Object)e.getMessage(), (Object)filePath);
        }
        return buffer.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean judgeTradingDay(String filePath, String today) {
        try (BufferedReader br = Files.newBufferedReader(Paths.get(filePath, new String[0]));){
            String day;
            do {
                if ((day = br.readLine()) == null) return false;
            } while (!today.equals(day));
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            log.error("judgeTradingDay Error , filePath:{}  Error: {}", (Object)filePath, (Object)e.getMessage());
        }
        return false;
    }

    public static class MyExtFilter
    implements FilenameFilter {
        private final String ext;

        public MyExtFilter(String ext) {
            this.ext = ext;
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(this.ext);
        }
    }
}

