/*
 * Decompiled with CFR 0.152.
 */
package com.zork.common.utils;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtil {
    private static final Logger log = LoggerFactory.getLogger(DateUtil.class);
    static String FORMAT_8_GAGE = "yyyy-MM-dd'T'HH:mm:ss+08:00";
    static String FORMAT_24 = "yyyy-MM-dd HH:mm:ss";

    public static String format24() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(FORMAT_24);
        return simpleDateFormat.format(new Date());
    }

    public static String format8Gage(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(FORMAT_8_GAGE);
        return simpleDateFormat.format(date);
    }

    public static Date lastFewMinutes(int minutes) {
        Calendar beforeTime = Calendar.getInstance();
        beforeTime.add(12, -minutes);
        return beforeTime.getTime();
    }

    public static String yearMonthDayBar() {
        SimpleDateFormat yearMonthDay = new SimpleDateFormat("YYYY-MM-dd");
        return yearMonthDay.format(new Date());
    }

    public static String yearMonthDayPoint() {
        SimpleDateFormat yearMonthDay = new SimpleDateFormat("YYYY.MM.dd");
        return yearMonthDay.format(new Date());
    }

    public static String yearMonthDayDigital() {
        SimpleDateFormat yearMonthDay = new SimpleDateFormat("YYYYMMdd");
        return yearMonthDay.format(new Date());
    }

    public static long dateToStamp(String time) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            return sdf.parse(time).getTime();
        }
        catch (ParseException e) {
            e.printStackTrace();
            return System.currentTimeMillis();
        }
    }

    public static Integer getWeek() {
        String week = "";
        Date today = new Date();
        Calendar c = Calendar.getInstance();
        c.setTime(today);
        return c.get(7);
    }

    public static Date utcToLocal(String utcTime) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        Date utcDate = new Date();
        try {
            utcDate = sdf.parse(utcTime);
        }
        catch (ParseException e) {
            log.error("\u8f6c\u6362\u65f6\u95f4\u9519\u8bef:{}", (Object)e.getMessage());
        }
        sdf.setTimeZone(TimeZone.getDefault());
        Date localDate = new Date();
        String localTime = sdf.format(utcDate.getTime());
        try {
            localDate = sdf.parse(localTime);
        }
        catch (ParseException e) {
            log.error("\u8f6c\u6362\u65f6\u95f4\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return localDate;
    }

    public static long utcToTimestamp(String utcTime) {
        return DateUtil.utcToLocal(utcTime).getTime();
    }

    public static String parseTime(String date) {
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss+08:00");
            return new SimpleDateFormat("HH:mm:ss").format(simpleDateFormat.parse(date));
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static long parseSSSTime(String date) {
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS+08:00");
            Calendar cal = Calendar.getInstance();
            cal.setTime(simpleDateFormat.parse(date));
            cal.add(10, 8);
            return cal.getTime().getTime();
        }
        catch (ParseException e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public static long parseSSSTime(String date, String foramt) {
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(foramt);
            Calendar cal = Calendar.getInstance();
            cal.setTime(simpleDateFormat.parse(date));
            cal.add(10, 8);
            return cal.getTime().getTime();
        }
        catch (ParseException e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public static long dateToStamp(String time, String pattern) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(pattern);
            return sdf.parse(time).getTime();
        }
        catch (ParseException e) {
            e.printStackTrace();
            return System.currentTimeMillis();
        }
    }

    public static Date beforeOrAfterNumberDay(Date date, int day) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(6, day);
        Date ofDate = cal.getTime();
        return ofDate;
    }

    public static String holidaysRequest(String httpArg) {
        String httpUrl = "http://tool.bitefu.net/jiari/";
        BufferedReader reader = null;
        String result = "";
        StringBuffer sbf = new StringBuffer();
        httpUrl = httpUrl + "?d=" + httpArg;
        try {
            URL url = new URL(httpUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.connect();
            InputStream is = connection.getInputStream();
            reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
            String strRead = "";
            while ((strRead = reader.readLine()) != null) {
                sbf.append(strRead);
            }
            reader.close();
            result = sbf.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u83b7\u53d6\u5f53\u5929\u662f\u5426\u4e3a\u8282\u5047\u65e5\u5931\u8d25:{}", (Object)e.getMessage());
        }
        return result;
    }

    public static String timeConsuming(long startTime, long endTime) {
        Long tempTime = endTime - startTime;
        return (tempTime / 86400000L > 0L ? tempTime / 86400000L + "d" : "") + (tempTime / 86400000L > 0L || tempTime % 86400000L / 3600000L > 0L ? tempTime % 86400000L / 3600000L + "h" : "") + (tempTime / 3600000L > 0L || tempTime % 3600000L / 60000L > 0L ? tempTime % 3600000L / 60000L + "m" : "") + (tempTime / 60000L > 0L || tempTime % 60000L / 1000L > 0L ? tempTime % 60000L / 1000L + "s" : "") + tempTime % 1000L + "ms";
    }

    public static String formatFullTime(LocalDateTime localDateTime) {
        return DateUtil.formatFullTime(localDateTime, "yyyyMMddHHmmss");
    }

    public static String formatFullTime(LocalDateTime localDateTime, String pattern) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(pattern);
        return localDateTime.format(dateTimeFormatter);
    }

    public static String getDateFormat(Date date, String dateFormatType) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(dateFormatType, Locale.CHINA);
        return simpleDateFormat.format(date);
    }

    public static String formatCSTTime(String date, String format) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy", Locale.US);
        Date usDate = simpleDateFormat.parse(date);
        return DateUtil.getDateFormat(usDate, format);
    }

    public static String formatInstant(Instant instant, String format) {
        LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
        return localDateTime.format(DateTimeFormatter.ofPattern(format));
    }
}

