package com.zork.other2jrsjcs.service.impl;

import com.zork.other2jrsjcs.dao.JrsjcsTypeaBizDao;
import com.zork.other2jrsjcs.model.JrsjcsTypeaBizDO;
import com.zork.other2jrsjcs.service.IJrsjcsTypeaBizService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.transaction.Transactional;
import java.util.List;

/**
 * @Author: Prock.Liy
 * @Date： 2021/9/6
 * @Description：
 */
@Service
public class JrsjcsTypeaBizImpl implements IJrsjcsTypeaBizService {

    @PersistenceContext
    private EntityManager entityManager;

    @Override
    @Transactional(rollbackOn = Exception.class)
    public void addBatch(List<JrsjcsTypeaBizDO> jrsjcsTypeaBizDOList) {
        jrsjcsTypeaBizDOList.forEach(jrsjcsTypeaBizDO -> {
            entityManager.persist(jrsjcsTypeaBizDO);
        });
        entityManager.flush();
        entityManager.close();
    }
}
