package com.zork.rankdata.component;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zork.common.dto.MetricDTO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.*;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

import static com.zork.common.constant.DimensionConstant.APP_SYSTEM;

/**
 * @Author: Prock.Liy
 * @Date： 2022/4/20
 * @Description： 查询es下当天所有指标的count条数以及大小指标
 */
@Slf4j
@Component
public class RankDataComponent {

    @Value("${send.url}")
    private String sendUrl;

    @Value("${request.url}")
    private String requestUrl;

    @Value("${metricsetname}")
    private String metricsetname;

    @Value("${request-param}")
    private String requestParam;

    @Value("${isFileJson}")
    private boolean isFileJson;

    @Resource
    private RestTemplate restTemplate;

    /**
     * thread pools   如果线程池长度超过处理需要，可灵活回收空闲线程，若无可回收，则新建线程
     */
    protected ExecutorService EXECUTOR_POOL = Executors.newCachedThreadPool();

    /**
     *
     */
    @Scheduled(cron = "${schedules}")
    public void execute() {
        try {
            int status = 200;
            ResponseEntity<JSONObject> result =  ResponseEntity.ok().body(JSONObject.parseObject("{\"code\":200,\"data\":[{\"rank\":1,\"performanceValue\":135.0,\"brokerName\":\"国泰君安\"},{\"rank\":2,\"performanceValue\":139.0,\"brokerName\":\"东吴证券\"},{\"rank\":3,\"performanceValue\":150.0,\"brokerName\":\"中泰证券\"}],\"msg\":\"\"}"));
            if (!isFileJson){
                HttpHeaders headers = new HttpHeaders();
                headers.setContentType(MediaType.APPLICATION_JSON);
                HttpEntity entity = new HttpEntity<>(JSONObject.toJSON(requestParam), headers);
                result = restTemplate.exchange(requestUrl, HttpMethod.POST, entity, JSONObject.class);
            }

            JSONArray jsonArray = Objects.requireNonNull(result.getBody()).getJSONArray("data");
            for (Object object : jsonArray) {
                // 获取index每日storeSize指标
                JSONObject rankDataObject = JSONObject.parseObject(JSON.toJSONString(object));

                Map<String, String> dimensions = new HashMap<>();
                Map<String, String> measures = new HashMap<>();

                dimensions.put("hostname", "jk-log-cjjgw");
                dimensions.put(APP_SYSTEM, "ZorkSystem");
                dimensions.put("rank",rankDataObject.getInteger("rank").toString());
                dimensions.put("brokerName",rankDataObject.getString("brokerName"));

                measures.put("value",rankDataObject.getFloat("performanceValue").toString());

                MetricDTO metricDTO = new MetricDTO();
                metricDTO.setMetricsetname(metricsetname);
                metricDTO.setDimensions(dimensions);
                metricDTO.setMeasures(measures);
                metricDTO.setTimestamp(new Date().getTime());

                // 发送数据至kafka
                sendMetric2Kafka(metricDTO);

            }
        } catch (Exception e) {
            log.error("\n RankData Exception: -> {}", e.getMessage());
        }
    }

    /**
     * 发送指标数据至Kafka
     *
     * @param metricDTO
     * @return JSONObject
     */
    private void sendMetric2Kafka(MetricDTO metricDTO) {
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            HttpEntity entity = new HttpEntity<>(JSONObject.toJSON(metricDTO), headers);
            ResponseEntity<String> result = restTemplate.exchange(sendUrl, HttpMethod.POST, entity, String.class);

            // 调用失败缺少measure值时，进行补齐重新调归补用递
            if (!Objects.requireNonNull(result.getBody()).contains("OK")) {
                log.info("sendMetric2Kafka SUCCESS,调用参数: ->{}  ,接口调用Result: ->{}", JSONObject.toJSON(metricDTO), result.getBody());
            }
        } catch (Exception e) {
            log.error("sendMetric2Kafka Exception: -> {} ,调用参数: ->{}", e.getMessage(), JSONObject.toJSON(metricDTO));
        }
    }

}
