package com.zork.zhtt.properties;

import com.zork.zhtt.dto.DataBaseDTO;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @Author: Prock.Liy
 * @Date： 2021/6/2
 * @Description：
 */
@Component
@ConfigurationProperties(prefix = DatabaseProperties.PROPERTIES_PREFIX )
@Data
public class DatabaseProperties {

    public static final String PROPERTIES_PREFIX = "database";

    /**
     * 数据库链接信息
     */
    private List<DataBaseDTO> dataBaseDTOList;

    public List<DataBaseDTO> getDataBaseDTOList() {
        return dataBaseDTOList;
    }

    public DatabaseProperties setDataBaseDTOList(List<DataBaseDTO> dataBaseDTOList) {
        this.dataBaseDTOList = dataBaseDTOList;
        return this;
    }
}
