package com.zork.zhtt.confg;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.core.JdbcTemplate;

import javax.sql.DataSource;

/**
 * @Author: Prock.Liy
 * @Date： 2021/6/17
 * @Description：JdbcTemplateConfig
 */
@Configuration
public class JdbcTemplateConfig {

    @Bean
    public JdbcTemplate jdbcTemplateQudkf(@Qualifier("qudkf") DataSource qudkf) {
        return new JdbcTemplate(qudkf);
    }

//    @Bean
//    public JdbcTemplate jdbcTemplateWskh(@Qualifier("wskh") DataSource wskh) {
//        return new JdbcTemplate(wskh);
//    }

    @Bean
    public JdbcTemplate jdbcTemplateWskhSlave1(@Qualifier("wskhslave1") DataSource wskhslave1) {
        return new JdbcTemplate(wskhslave1);
    }

}
