# !/bin/bash

#===========================================================================================
# APP_HOME=/opt/app/indices 工作目录，存放jar包和日志等相关文件
# APP_JAR=metric-es-indices-2.2-RELEASE.jar jar包全称
# JVM_OPTS="-Xms256m -Xmx256m" JVM启动参数
# APP_OPTS="--server.port=8080 --spring.profiles.active=dev" spring配置参数、main方法接收的参数
#===========================================================================================

APP_HOME=/opt/app/indices
APP_JAR=metric-es-indices-2.2-RELEASE.jar
APP_OPTS=""
JVM_OPTS="-Xms256m -Xmx256m"

function start(){
  findPid
    if [ -z "$pid" ]; then
    nohup java -jar $APP_HOME/$APP_JAR --spring.config.location=APP_HOME/application.yml,APP_HOME/application-datasource.yml > $APP_HOME/nohup.out 2>&1 &
      colorPrint $GREEN "$APP_JAR 已启动"
    else
      colorPrint $YELLOW "$APP_JAR 启动失败，已存在运行的进程，进程ID为 $pid"
        exit 1
    fi
}

function startForeground(){
  findPid
    if [ -z "$pid" ]; then
      colorPrint $GREEN "$APP_JAR 开始启动"
    java -jar $JVM_OPTS $APP_HOME/$APP_JAR $APP_OPTS
    else
      colorPrint $YELLOW "$APP_JAR 启动失败，已存在运行的进程，进程ID为 $pid"
        exit 1
    fi
}

function stop(){
  findPid
    if [ -z "$pid" ]; then
      colorPrint $YELLOW "$APP_JAR 停止失败，未找到运行的进程"
    else
    kill -TERM $pid
      colorPrint $GREEN "$APP_JAR 已停止ID为 $pid 的进程"
    fi
}

function restart(){
    stop
    sleep 3
    start
}

function status() {
    info=$(jps -mlvV | grep $APP_JAR)
    if [ -z "$info" ]; then
      colorPrint $YELLOW "$APP_JAR 未找到运行的进程"
    else
      echo $info
    fi
}

# 根据APP_JAR查找进程ID
pid=0
function findPid(){
    pid=$(jps -l | grep $APP_JAR | awk '{print $1}')
}

# 按指定的颜色打印字符串。第一个参数是颜色，第二个参数是打印的字符串
RED=31 GREEN=32 YELLOW=33
function colorPrint(){
    echo -e "\033[$135m $2 \033[0m"
}

case "$1" in
    start)
    start
    ;;
    start-foreground)
    startForeground
    ;;
    stop)
    stop
    ;;
    restart)
    restart
    ;;
    status)
    status
    ;;
    *)
    colorPrint $RED "Usage: {start | start-foreground | stop| restart | status} {后台启动|前台启动|停止|重启|查看进程状态}"
    exit 1
    ;;
esac

