package com.zork.junhiro.trading.count.config;

import com.zork.common.service.InfluxDBService;
import lombok.Data;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import static com.zork.common.constant.InfluxDBConstant.AUTOGEN;

/**
 * @Author: Prock.Liy
 * @Date： 2021/6/16
 * @Description：
 */
@ConfigurationProperties("application.yml")
@Configuration
@Data
public class InfluxDBConfig {

    @Value("${spring.influx.url}")
    private String influxUrl;

    @Value("${spring.influx.user}")
    private String influxUser;

    @Value("${spring.influx.password}")
    private String influxPass;

    @Value("${spring.influx.database}")
    private String influxDataBase;

    public InfluxDBService getInfluxDBService(){
        InfluxDBService influxDBService = new InfluxDBService(influxUser, influxPass, influxUrl, influxDataBase);
        influxDBService.influxDbBuild();
        influxDBService.createRetentionPolicy(AUTOGEN);
        return influxDBService;
    }

}
