package com.zork.common.service;

import lombok.extern.slf4j.Slf4j;
import org.influxdb.InfluxDB;
import org.influxdb.InfluxDBFactory;
import org.influxdb.dto.Query;
import org.influxdb.dto.QueryResult;

@Slf4j
public class InfluxDBService {
    private InfluxDB influxDB;
    private String database;

    public InfluxDBService(String username, String password, String url, String database) {
        this.database = database;
        this.influxDB = InfluxDBFactory.connect(url, username, password);
    }

    public void influxDbBuild() {
        influxDB.setDatabase(database);
    }

    public void createRetentionPolicy(String policyName) {
        // 创建保留策略的逻辑
    }

    public QueryResult query(String command) {
        return influxDB.query(new Query(command, database));
    }

    public void close() {
        if (influxDB != null) {
            influxDB.close();
        }
    }

    public static QueryResult.Series getResult(QueryResult queryResult) {
        if (queryResult != null && queryResult.getResults() != null 
            && !queryResult.getResults().isEmpty()
            && queryResult.getResults().get(0).getSeries() != null
            && !queryResult.getResults().get(0).getSeries().isEmpty()) {
            return queryResult.getResults().get(0).getSeries().get(0);
        }
        return null;
    }
}