package com.zork.common.utils;

import com.zork.common.constant.DateConstant;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

/**
 * @Author Prock.Liy
 * @Date 2020/10/11 22:22
 * @Description
 **/
@Slf4j
public class DateUtil {

    static String FORMAT_8_GAGE = "yyyy-MM-dd'T'HH:mm:ss+08:00";

    static String FORMAT_24 = "yyyy-MM-dd HH:mm:ss";

//    public static void main(String[] args) throws ParseException {
//        String date = StringUtils.substringBefore("2022-09-02T09:33:42.360811787Z",".");
//        System.out.println(date);
//        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
//        Calendar cal = Calendar.getInstance();
//        cal.setTime(simpleDateFormat.parse(date));
//        cal.add(Calendar.HOUR, 8);
//        System.out.println(cal.getTime());
////        System.out.println(parseSSSTime("2022-09-02T09:33:42.360811787Z"));
//    }

    /**
     * 转换获取+08时间格式
     *
     * @return
     */
    public static String format24() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(FORMAT_24);
        return simpleDateFormat.format(new Date());
    }

    /**
     * 转换获取+08时间格式
     *
     * @param date
     * @return
     */
    public static String format8Gage(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(FORMAT_8_GAGE);
        return simpleDateFormat.format(date);
    }

    /**
     * 获取过去几分钟时间
     *
     * @param minutes 分钟
     * @return
     */
    public static Date lastFewMinutes(int minutes) {
        Calendar beforeTime = Calendar.getInstance();
        beforeTime.add(Calendar.MINUTE, -minutes);
        return beforeTime.getTime();
    }

    /**
     * 获取年月日时间格式  2022.04.08
     *
     * @return
     */
    public static String yearMonthDayBar() {
        SimpleDateFormat yearMonthDay = new SimpleDateFormat("YYYY-MM-dd");
        return yearMonthDay.format(new Date());
    }

    /**
     * 获取年月日时间格式  2022.04.08
     *
     * @return
     */
    public static String yearMonthDayPoint() {
        SimpleDateFormat yearMonthDay = new SimpleDateFormat("YYYY.MM.dd");
        return yearMonthDay.format(new Date());
    }

    /**
     * 获取年月日时间格式  20220408
     *
     * @return
     */
    public static String yearMonthDayDigital() {
        SimpleDateFormat yearMonthDay = new SimpleDateFormat("YYYYMMdd");
        return yearMonthDay.format(new Date());
    }

    /**
     * 将时间转换为时间戳
     *
     * @param time
     * @return
     */
    public static long dateToStamp(String time) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            return sdf.parse(time).getTime();
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return System.currentTimeMillis();
    }

    /**
     * 获取当天是周几
     *
     * @return
     */
    public static Integer getWeek() {
        String week = "";
        Date today = new Date();
        Calendar c = Calendar.getInstance();
        c.setTime(today);
        return c.get(Calendar.DAY_OF_WEEK);
    }

    /**
     * UTC时间转化为本地时间
     *
     * @param utcTime utc 时间字符串
     * @return Date
     */
    public static Date utcToLocal(String utcTime) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        Date utcDate = new Date();
        try {
            utcDate = sdf.parse(utcTime);
        } catch (ParseException e) {
            log.error("转换时间错误:{}", e.getMessage());
        }
        sdf.setTimeZone(TimeZone.getDefault());
        Date localDate = new Date();
        String localTime = sdf.format(utcDate.getTime());
        try {
            localDate = sdf.parse(localTime);
        } catch (ParseException e) {
            log.error("转换时间错误:{}", e.getMessage());
        }
        return localDate;
    }

    /**
     * 将 utc 格式的时间转换成 时间戳
     *
     * @param utcTime 2019-12-19T05:54:00Z
     * @return long
     */
    public static long utcToTimestamp(String utcTime) {
        return utcToLocal(utcTime).getTime();
    }

    /**
     * utc转换时间格式为时分
     *
     * @param date
     * @return String
     */
    public static String parseTime(String date) {
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss+08:00");
            return new SimpleDateFormat("HH:mm:ss").format(simpleDateFormat.parse(date));
        } catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    /**
     * utc转换时间格式为时分
     *
     * @param date
     * @return String
     */
    public static long parseSSSTime(String date) {
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS+08:00");
            Calendar cal = Calendar.getInstance();
            cal.setTime(simpleDateFormat.parse(date));
            cal.add(Calendar.HOUR, 8);
            return cal.getTime().getTime();
        } catch (ParseException e) {
            e.printStackTrace();
            return 0L;
        }
    }

    /**
     * utc转换时间格式为时分
     *
     * @param date
     * @return String
     */
    public static long parseSSSTime(String date, String foramt) {
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(foramt);
            Calendar cal = Calendar.getInstance();
            cal.setTime(simpleDateFormat.parse(date));
            cal.add(Calendar.HOUR, 8);
            return cal.getTime().getTime();
        } catch (ParseException e) {
            e.printStackTrace();
            return 0L;
        }
    }


    /**
     * 将时间转换为时间戳
     *
     * @param time
     * @return
     */
    public static long dateToStamp(String time, String pattern) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(pattern);
            return sdf.parse(time).getTime();
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return System.currentTimeMillis();
    }

    /**
     * 查询当前日期前(后)x天的日期
     *
     * @param date 当前日期
     * @param day  天数（如果day数为负数,返回日期前的天数）
     * @return yyyyMMdd
     */
    public static Date beforeOrAfterNumberDay(Date date, int day) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(Calendar.DAY_OF_YEAR, day);
        Date ofDate = cal.getTime();
        return ofDate;
    }

    /**
     * 判断当前是否为节假日： 0 上班 1周末 2节假日
     *
     * @param httpArg :参数
     * @return 返回结果
     */

    public static String holidaysRequest(String httpArg) {
        String httpUrl = "http://tool.bitefu.net/jiari/";
        BufferedReader reader = null;
        String result = StringUtils.EMPTY;
        StringBuffer sbf = new StringBuffer();
        httpUrl = httpUrl + "?d=" + httpArg;
        try {
            URL url = new URL(httpUrl);
            HttpURLConnection connection = (HttpURLConnection) url.openConnection();
            connection.setRequestMethod("GET");
            connection.connect();
            InputStream is = connection.getInputStream();
            reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
            String strRead = StringUtils.EMPTY;
            while ((strRead = reader.readLine()) != null) {
                sbf.append(strRead);
            }
            reader.close();
            result = sbf.toString();
        } catch (Exception e) {
            e.printStackTrace();
            log.error("获取当天是否为节假日失败:{}", e.getMessage());
        }
        return result;
    }

    /**
     * 计算耗时
     *
     * @param startTime 开始时间
     * @param endTime   结束时间
     * @return
     */
    public static String timeConsuming(long startTime, long endTime) {
        Long tempTime = (endTime - startTime);
        return (((tempTime / 86400000) > 0) ? ((tempTime / 86400000) + "d") : "") +
                ((((tempTime / 86400000) > 0) || ((tempTime % 86400000 / 3600000) > 0)) ? ((tempTime % 86400000 / 3600000) + "h") : ("")) +
                ((((tempTime / 3600000) > 0) || ((tempTime % 3600000 / 60000) > 0)) ? ((tempTime % 3600000 / 60000) + "m") : ("")) +
                ((((tempTime / 60000) > 0) || ((tempTime % 60000 / 1000) > 0)) ? ((tempTime % 60000 / 1000) + "s") : ("")) +
                ((tempTime % 1000) + "ms");
    }

    public static String formatFullTime(LocalDateTime localDateTime) {
        return formatFullTime(localDateTime, DateConstant.FULL_TIME_PATTERN);
    }

    public static String formatFullTime(LocalDateTime localDateTime, String pattern) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(pattern);
        return localDateTime.format(dateTimeFormatter);
    }

    public static String getDateFormat(Date date, String dateFormatType) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(dateFormatType, Locale.CHINA);
        return simpleDateFormat.format(date);
    }

    public static String formatCSTTime(String date, String format) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DateConstant.CST_TIME_PATTERN, Locale.US);
        Date usDate = simpleDateFormat.parse(date);
        return DateUtil.getDateFormat(usDate, format);
    }

    public static String formatInstant(Instant instant, String format) {
        LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
        return localDateTime.format(DateTimeFormatter.ofPattern(format));
    }
}
