package com.zork.zhtt.confg;

import com.alibaba.druid.spring.boot.autoconfigure.DruidDataSourceBuilder;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import javax.sql.DataSource;

/**
 * @Author: Prock.Liy
 * @Date： 2021/6/7
 * @Description：数据源Config
 */
@Configuration
public class DataSourceConfig {

    @Bean
    @ConfigurationProperties(prefix = "spring.datasource.qudkf")
    public DataSource qudkf() {
        return DruidDataSourceBuilder.create().build();
    }

//    @Bean
//    @ConfigurationProperties(prefix = "spring.datasource.wskh")
//    public DataSource wskh() {
//        return DruidDataSourceBuilder.create().build();
//    }

    @Bean
    @ConfigurationProperties(prefix = "spring.datasource.wskhslave1")
    public DataSource wskhslave1() {
        return DruidDataSourceBuilder.create().build();
    }

}
