package com.zork.junhiro.trading.count.config;

import com.alibaba.druid.spring.boot.autoconfigure.DruidDataSourceBuilder;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import javax.sql.DataSource;

/**
 * @Author: Prock.Liy
 * @Date： 2021/6/7
 * @Description：数据源Config
 */
@Configuration
public class DataSourceConfig {

    @Bean
    @ConfigurationProperties(prefix = "spring.datasource.msdb")
    public DataSource msdb() {
        return DruidDataSourceBuilder.create().build();
    }
    @Bean
    @ConfigurationProperties(prefix = "spring.datasource.app-business")
    public DataSource appBusiness() {
        return DruidDataSourceBuilder.create().build();
    }

}
