package com.zork.htpocesb;

import com.zork.htpocesb.constant.DataConstant;
import com.zork.common.service.InfluxDBService;
import com.zork.htpocesb.thread.CompletableFutureAsync;
import com.zork.common.utils.FileUtil;
import com.zork.common.utils.DateUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;

import java.io.File;
import java.util.Arrays;

import static com.zork.htpocesb.component.CsvWriteInfluxDBComponent.invoke;

@Slf4j
public class HtpocesbApplication {

    /**
     * 程序入口
     *
     * @param args 传入文件路径
     */
    public static void main(String[] args) {
        if (args.length != 5) {
            log.error("启动参数错误:{},请输入正确参数格式！",
                    args);
            log.error("参考如下: {}",
                    "【java -jar htpocesb-0.0.1-SNAPSHOT.jar username password url database csvFile】");
            return;
        }

        InfluxDBService influxDBConnect = new InfluxDBService(args[0], args[1], args[2], args[3]);

        File file = new File(args[4]);
        if (file.isDirectory()) {
            // 读取文件夹下csv类型文件名称
            String[] csvFile = (new File(args[4])).list(new FileUtil.MyExtFilter(DataConstant.CSV));
            assert csvFile != null;
            // CompletableFutureAsync执行任务
            CompletableFutureAsync.execute(influxDBConnect, args[4], Arrays.asList(csvFile));
            return;
        }
        if (!file.exists()) {
            log.error("该文件:{},不存在!", args[4]);
            return;
        }
        if (file.isFile()) {
            String fileSuffix = StringUtils.substringAfter(args[4], ".");
            if (!DataConstant.CSV.equals(fileSuffix)) {
                log.error("请输入正确的csv文件路径!");
                return;
            }
            log.info("Start to read Csv file data, file path:  【\033[31m{}\033[0m】", args[4]);
            long startTime = System.currentTimeMillis();
            invoke(influxDBConnect, args[4]);
            log.info("Task execution success, time-consuming:【\033[31m{}\033[0m】", DateUtil.timeConsuming(startTime, System.currentTimeMillis()));
        }
    }

}
