package com.zork.common.utils;

import com.zork.common.dto.ExecuteResultDTO;
import lombok.extern.slf4j.Slf4j;
import org.apache.ibatis.io.Resources;
import org.apache.ibatis.jdbc.ScriptRunner;

import java.io.*;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DriverManager;

/**
 * @Author: Prock.Liy
 * @Date： 2021/6/4
 * @Description：
 */
@Slf4j
public class SqlFileExecuteUtil {

    /**
     * 执行Sql文件
     * @param taskStepId    任务号ID
     * @param url           数据库URL
     * @param userName      用户名
     * @param userPassword  密码
     * @param filePath      Sql文件Path
     * @return  Execute
     * @throws IOException
     */
    public static ExecuteResultDTO executeSql(String taskStepId, String url, String userName, String userPassword, String filePath) throws IOException {
        ExecuteResultDTO executeResult = new ExecuteResultDTO();
        executeResult.setTaskStepId(taskStepId);
        // sql执行输出流
        StringWriter succeedWriter = new StringWriter();
        PrintWriter succeedOut = new PrintWriter(succeedWriter);
        StringWriter errorWriter = new StringWriter();
        PrintWriter errorOut = new PrintWriter(errorWriter);
        Connection conn = null;
        ScriptRunner runner;

        try {
            conn = getMySqlConnection(url, userName, userPassword);
        } catch (Exception e) {
            e.printStackTrace();
            executeResult.setStatus(1);
            executeResult.setLog(e.getStackTrace().toString());
            e.printStackTrace();
            log.error("ExecuteSqlException: "+e.getMessage());
            try {
                conn.close();
            } catch (Exception ee) {
                ee.printStackTrace();
                log.error("ExecuteSqlException: "+url + "关闭连接错误!");
            }
            return executeResult;
        }
        runner = new ScriptRunner(conn);
        // 设置字符集,不然中文乱码插入错误
        Resources.setCharset(StandardCharsets.UTF_8);
        runner.setAutoCommit(false);
        runner.setSendFullScript(true);
        // 设置日志
        runner.setLogWriter(succeedOut);
        runner.setErrorLogWriter(errorOut);
        // 遇到错误停止
        runner.setStopOnError(true);
        // 绝对路径读取
        Reader read = new FileReader(filePath);
        try {
            runner.runScript(read);
        } catch (Exception e) {
            e.printStackTrace();
            executeResult.setStatus(1);
            executeResult.setLog(errorWriter.toString());
            log.error("ExecuteSqlException: "+e.getMessage());
            return executeResult;
        } finally {
            try {
                runner.closeConnection();
                conn.close();
            } catch (Exception e) {
                e.printStackTrace();
                log.error("ExecuteSqlException:   "+url + "关闭连接错误!");
            }
        }
        executeResult.setSucceed(true);
        executeResult.setLog(succeedWriter.getBuffer().toString());
        executeResult.setStatus(0);
        return executeResult;
    }

    /**
     * @return
     * @throws Exception
     * @功能描述： 获取数据库连接
     */
    public static Connection getMySqlConnection(String url, String userName, String userPassword) throws Exception {
        Class.forName("com.microsoft.sqlserver.jdbc.SQLServerDriver");
        return DriverManager.getConnection(url, userName, userPassword);
    }

}
