/*
 * Decompiled with CFR 0.152.
 */
package com.zork.common.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zork.common.utils.DateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class RestTemplateUtil {
    private static final Logger log = LoggerFactory.getLogger(RestTemplateUtil.class);
    private static final RestTemplate restTemplate = new RestTemplate();

    public static JSONArray getJSONArray(String url) {
        JSONArray jsonArray = new JSONArray();
        try {
            jsonArray = (JSONArray)restTemplate.exchange(url, HttpMethod.GET, null, JSONArray.class, new Object[0]).getBody();
        }
        catch (Exception e) {
            log.error("getJSONArray RestTemplate Error:{}", (Object)e.getMessage());
        }
        return jsonArray;
    }

    public static JSONObject postJSONObject(String url, JSONObject param) {
        JSONObject jsonObject = new JSONObject();
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            HttpEntity entity = new HttpEntity((Object)param, (MultiValueMap)headers);
            ResponseEntity result = restTemplate.exchange(String.format(url, DateUtil.yearMonthDayPoint()), HttpMethod.POST, entity, JSONObject.class, new Object[0]);
            jsonObject = (JSONObject)result.getBody();
        }
        catch (Exception e) {
            log.error("postJSONObject RestTemplate Error:{}", (Object)e.getMessage());
        }
        return jsonObject;
    }
}

