/*
 * Decompiled with CFR 0.152.
 */
package com.zork.common.service;

import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.influxdb.InfluxDB;
import org.influxdb.InfluxDBFactory;
import org.influxdb.dto.BatchPoints;
import org.influxdb.dto.Point;
import org.influxdb.dto.Query;
import org.influxdb.dto.QueryResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfluxDBService {
    private static final Logger log = LoggerFactory.getLogger(InfluxDBService.class);
    private String username;
    private String password;
    private String openurl;
    private String database;
    private InfluxDB influxDB;

    public InfluxDBService(String username, String password, String openurl, String database) {
        this.username = username;
        this.password = password;
        this.openurl = openurl;
        this.database = database;
    }

    public InfluxDB influxDbBuild() {
        if (this.influxDB == null) {
            this.influxDB = InfluxDBFactory.connect((String)this.openurl, (String)this.username, (String)this.password);
            this.influxDB.createDatabase(this.database);
        }
        return this.influxDB;
    }

    public void createRetentionPolicy(String policy) {
        String command = String.format("CREATE RETENTION POLICY \"%s\" ON \"%s\" DURATION %s REPLICATION %s DEFAULT", policy, this.database, "7200d", 1);
        this.query(command);
    }

    public QueryResult query(String command) {
        return this.influxDB.query(new Query(command, this.database));
    }

    public QueryResult query(String command, TimeUnit unit) {
        return this.influxDB.query(new Query(command, this.database), unit);
    }

    public void insert(String measurement, Map<String, String> tags, Map<String, Object> fields, long time) {
        Point.Builder builder = Point.measurement((String)measurement);
        builder.time(time, TimeUnit.MILLISECONDS);
        builder.tag(tags);
        builder.fields(fields);
        this.influxDB.write(this.database, "", builder.build());
    }

    public void insert(String measurement, Map<String, String> tags, Map<String, Object> fields) {
        Point.Builder builder = Point.measurement((String)measurement);
        builder.tag(tags);
        builder.fields(fields);
        this.influxDB.write(this.database, "", builder.build());
    }

    public void pointInsert(String autogen, Point point) {
        this.influxDB.write(this.database, "", point);
    }

    public void batchInsert(BatchPoints batchPoints) {
        this.influxDB.write(batchPoints);
    }

    public void insertBatch(List<Point> pointList, int batchSize) {
        Long startTime = System.currentTimeMillis();
        BatchPoints batchPoints = BatchPoints.database((String)this.database).consistency(InfluxDB.ConsistencyLevel.ALL).build();
        int i = 0;
        for (Point point : pointList) {
            batchPoints.point(point);
            if (++i / batchSize != 1) continue;
            i = 0;
            this.influxDB.write(batchPoints);
            batchPoints = BatchPoints.database((String)this.database).consistency(InfluxDB.ConsistencyLevel.ALL).build();
        }
        this.influxDB.write(batchPoints);
        Long endTime = System.currentTimeMillis();
    }

    public String deleteMeasurementData(String command) {
        QueryResult result = this.influxDB.query(new Query(command, this.database));
        return result.getError();
    }

    public void createDB(String dbName) {
        this.influxDB.createDatabase(dbName);
    }

    public void deleteDB(String dbName) {
        this.influxDB.deleteDatabase(dbName);
    }

    public static QueryResult.Series getResult(QueryResult queryResult) {
        List results = queryResult.getResults();
        if (results == null || ((QueryResult.Result)results.get(0)).getSeries() == null) {
            return null;
        }
        QueryResult.Result result = (QueryResult.Result)results.get(0);
        return result.getSeries().isEmpty() ? null : (QueryResult.Series)result.getSeries().get(0);
    }

    public void close() {
        this.influxDB.close();
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getOpenurl() {
        return this.openurl;
    }

    public String getDatabase() {
        return this.database;
    }

    public InfluxDB getInfluxDB() {
        return this.influxDB;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setOpenurl(String openurl) {
        this.openurl = openurl;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public void setInfluxDB(InfluxDB influxDB) {
        this.influxDB = influxDB;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InfluxDBService)) {
            return false;
        }
        InfluxDBService other = (InfluxDBService)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$openurl = this.getOpenurl();
        String other$openurl = other.getOpenurl();
        if (this$openurl == null ? other$openurl != null : !this$openurl.equals(other$openurl)) {
            return false;
        }
        String this$database = this.getDatabase();
        String other$database = other.getDatabase();
        if (this$database == null ? other$database != null : !this$database.equals(other$database)) {
            return false;
        }
        InfluxDB this$influxDB = this.getInfluxDB();
        InfluxDB other$influxDB = other.getInfluxDB();
        return !(this$influxDB == null ? other$influxDB != null : !this$influxDB.equals(other$influxDB));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InfluxDBService;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $openurl = this.getOpenurl();
        result = result * 59 + ($openurl == null ? 43 : $openurl.hashCode());
        String $database = this.getDatabase();
        result = result * 59 + ($database == null ? 43 : $database.hashCode());
        InfluxDB $influxDB = this.getInfluxDB();
        result = result * 59 + ($influxDB == null ? 43 : $influxDB.hashCode());
        return result;
    }

    public String toString() {
        return "InfluxDBService(username=" + this.getUsername() + ", password=" + this.getPassword() + ", openurl=" + this.getOpenurl() + ", database=" + this.getDatabase() + ", influxDB=" + this.getInfluxDB() + ")";
    }
}

