package com.zorkdata.datamask.util;

/**
 * @author 谢森
 * @Description 配置文件工具类
 * @Email xiesen@zork.com.cn
 */
public class ConfigUtils {
    public static final String EMPTY_STR = "";
    public static final String NULL_STR = "null";

    public static String getString(String value, String defaultValue) {
        String result = value == null || EMPTY_STR.equals(value) || NULL_STR.equals(value) ? defaultValue : value;
        return result;
    }

    public static Integer getInteger(Integer value, Integer defaultValue) {
        Integer result = value < 0 ? defaultValue : value;
        return result;
    }

    public static Double getDouble(Double value, Double defaultValue) {
        Double result = value == null ? defaultValue : value;
        return result;
    }

    public static Float getFloat(Float value, Float defaultValue) {
        Float result = value == null ? defaultValue : value;
        return result;
    }

    public static Long getLong(Long value, Long defaultValue) {
        Long result = value == null ? defaultValue : value;
        return result;
    }

    public static Boolean getBoolean(Boolean value, Boolean defaultValue) {
        Boolean result = value == null ? defaultValue : value;
        return result;
    }
}
