package com.zorkdata.datamask.util;

import com.alibaba.fastjson.JSON;
import com.zorkdata.datamask.domain.LogData;
import com.zorkdata.datamask.domain.TransactionLog;
import com.zorkdata.datamask.util.avro.AvroDeserializer;
import com.zorkdata.datamask.util.avro.AvroDeserializerFactory;
import com.zorkdata.datamask.util.avro.AvroSerializerFactory;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificDatumWriter;

import java.io.*;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.TimeZone;

/**
 * Description :
 *  https://www.cnblogs.com/fillPv/p/5009737.html
 * @author : wanghaiying (<a href="wanghaiying@zorkdata.com.cn">wanghaiying@zorkdata.com.cn</a>)
 * Date : Create in 2020/9/23 4:43
 */

// java -jar avro-tools-1.10.0.jar compile schema log.avro .
//
public class AvroTest {
    public static void main(String[] args) throws IOException {

        // Avro序列化，写avro文件
//        TransactionLog transactionLog = new TransactionLog();
//        LogData transactionLog = new LogData();
//        transactionLog.setLogTypeName("kcbp_biz_log");
//        transactionLog.setTimestamp("2020-09-18T13:59:53.000+08:00");
//        transactionLog.setSource("d:\\\\kcbp\\\\log\\\\run\\\\20200918\\\\runlog23.log");
//        transactionLog.setOffset("165683111");
//
//        HashMap dimensions = new HashMap() {{
//            put("appsystem", "jzjy");
//            put("appprogramname", "jzc9-kcbp1_9600");
//            put("hostname", "jzc9-kcbp1");
//            put("func", "");
//            put("nodeid", "");
//            put("operway", "W");
//        }};
////        transactionLog.setDimensions(dimensions);
//
//        HashMap measures = new HashMap<String, Double>() {{
//            put("latence", 0.0);
//            put("latency", 1.0);
//            put("spendtime", 0.5);
//        }};
////        transactionLog.setMeasures(measures);
//
//        HashMap normalFields = new HashMap() {{
//            put("indexTime", "2020-09-18T13:59:54.524+08:00");
//            put("bsflag", "");
//            put("productcode", "");
//            put("developercode", "");
//            put("fmillsecond", "");
//            put("inputtype", "");
//            put("logchecktime", "");
//            put("message", "身份证号码：372925199008075158,地址:上海浦东新区张江高科碧波路690号，手机号:15000101879,邮箱:wanghaiying@zork.com.cn");
//            put("end_logtime", "");
//            put("smillsecond", "585606599");
//            put("featurecode", "");
//            put("orgid", "");
//            put("authcode", "");
//            put("collecttime", "2020-09-18T13:59:53.529+08:00");
//            put("fundid", "");
//            put("deserializerTime", "2020-09-18T13:59:53.671+08:00");
//            put("messid", "0000011404342B32233DDCDA");
//            put("custid", "");
//            put("netputr", "");
//            put("versioninfo", "");
//            put("beg_logtime", "20200918-135953");
//            put("authinfo", "");
//        }};
//        transactionLog.setNormalFields(normalFields);

//        String path = "d:\\transactionlog-20200925.avro"; // avro文件存放目录
//        DatumWriter<TransactionLog> logDatumWriter = new SpecificDatumWriter<>(TransactionLog.class);
//        DataFileWriter<TransactionLog> dataFileWriter = new DataFileWriter<>(logDatumWriter);
//        dataFileWriter.create(transactionLog.getSchema(),  new File(path));
//        // 把生成的对象写入到avro文件
//        dataFileWriter.append(transactionLog);
//        dataFileWriter.append(transactionLog);
//        dataFileWriter.append(transactionLog);
//        dataFileWriter.close();
        /**
         * 序列化
         */
//        byte[] kcbp_biz_logs = AvroSerializerFactory.getLogAvroSerializer().serializingLog("kcbp_biz_log", "2020-09-18T13:59:53.000+08:00",
//                "d:\\\\kcbp\\\\log\\\\run\\\\20200918\\\\runlog23.log", "165683111", dimensions, measures, normalFields);
//        FileOutputStream fos = null;
//        try {
//            fos = new FileOutputStream("d:\\transactionlog-20201009.avro");
//        } catch (FileNotFoundException e) {
//            e.printStackTrace();
//        }
//        try {
//            fos.write(kcbp_biz_logs,0,kcbp_biz_logs.length);
//            fos.flush();
//            fos.close();
//        } catch (IOException e) {
//            e.printStackTrace();
//        }

        /**
         * 反序列化
         */
//        File file = new File("d:\\part-0-0.avro");
//        File file = new File("d:\\hdfs-transactionlog-20200929.avro");
//        File file = new File("d:\\transactionlog-20201009.avro");
//        byte[] byteBuffer = new byte[(int) file.length()];
//
//        FileInputStream fileInputStream = null;
//        try {
////            fileInputStream = new FileInputStream("d:\\part-0-0.avro");
//            fileInputStream = new FileInputStream("d:\\transactionlog-20201009.avro");
//        } catch (FileNotFoundException e) {
//            e.printStackTrace();
//        }
//        try {
//            fileInputStream.read(byteBuffer);
//        } catch (IOException e) {
//            e.printStackTrace();
//        }
//        GenericRecord genericRecord = AvroDeserializerFactory.getLogsDeserializer().deserializing(byteBuffer);
//        System.out.println(genericRecord);

        // 读取avro文件，反序列化
//        DatumReader<LogData> reader = new SpecificDatumReader<LogData>(LogData.class);
////        DataFileReader<LogData> dataFileReader = new DataFileReader<LogData>(new File("d:\\part-0-0.avro"), reader);
//        DataFileReader<LogData> dataFileReader = new DataFileReader<LogData>(new File("d:\\transactionlog-20201009.avro"), reader);
//        LogData transactionLogRead = null;
//        while (dataFileReader.hasNext()) {
//            transactionLogRead = dataFileReader.next();
//            System.out.println(transactionLogRead);
//        }

        Schema schema = new Schema.Parser().parse(new File("d:\\log.avro"));
        GenericRecord emp = new GenericData.Record(schema);
        File file = new File("d:\\1 (1).avro");

        DatumReader<GenericRecord> datumReader = new GenericDatumReader<GenericRecord>(schema);
        DataFileReader<GenericRecord> dataFileReader = new DataFileReader<GenericRecord>(file, datumReader);

        while (dataFileReader.hasNext())
        {
            emp = dataFileReader.next();
            System.out.println(emp);
        }

//        Long aLong = utc2Local("2020-09-29T09:36:20.626+08:00");
//        System.out.println(aLong);
    }

    public static Long utc2Local(String utcTime) {
        SimpleDateFormat utcFormater = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS+08:00");
        utcFormater.setTimeZone(TimeZone.getTimeZone("UTC"));//时区定义并进行时间获取
        Date gpsUTCDate = null;
        try {
            gpsUTCDate = utcFormater.parse(utcTime);
        } catch (ParseException e) {
            System.out.println("时间戳格式转换异常：" + utcTime + e.getMessage());
        }
        return gpsUTCDate.getTime();
    }
}
