package com.zorkdata.datamask.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

/**
 * @author 谢森
 * @Description 时间处理工具类
 * @Email xiesen310@163.com
 * @Date 2020/10/21 14:39
 */
public class DateUtils {
    public static final Logger logger = LoggerFactory.getLogger(DateUtils.class);
    private static SimpleDateFormat utcFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS+08:00");

    /**
     * UTC时间转
     *
     * @param utcTime UTC时间
     * @return unix时间戳
     */
    public static Long utc2timestamp(String utcTime) {
        //时区定义并进行时间获取
        utcFormatter.setTimeZone(TimeZone.getTimeZone("asia/shanghai"));
        Date gpsUtcDate = null;
        try {
            gpsUtcDate = utcFormatter.parse(utcTime);
        } catch (ParseException e) {
            logger.error("时间戳格式转换异常：{} 原因: {}", utcTime, e.getMessage());
            return null;
        }
        return gpsUtcDate.getTime();
    }
}
