package com.zorkdata.datamask.function;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.zorkdata.datamask.domain.LogData;
import com.zorkdata.datamask.util.avro.AvroDeserializer;
import com.zorkdata.datamask.util.avro.AvroDeserializerFactory;
import lombok.extern.slf4j.Slf4j;
import org.apache.avro.generic.GenericRecord;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.RichFlatMapFunction;
import org.apache.flink.util.Collector;

/**
 * @author xiese
 * @Description Avro2StrFlatMapFunction
 * @Email xiesen310@163.com
 * @Date 2020/9/26 23:14
 */
@Slf4j
public class Avro2StrFlatMapFunction implements FlatMapFunction<String, LogData> {

    @Override
    public void flatMap(String value, Collector<LogData> out) throws Exception {
        try {
            if (null != value) {
                AvroDeserializer logsDeserializer = AvroDeserializerFactory.getLogsDeserializer();
                GenericRecord record = logsDeserializer.deserializing(value.getBytes());
//                System.out.println("----------record---------"+record);

                if (null != record) {
                    LogData logData = JSON.parseObject(record.toString(), new TypeReference<LogData>() {
                    });
//                    System.out.println("----------logData---------"+logData);
//                    out.collect(JSON.toJSONString(logData));
                    out.collect(logData);
                }
            }
        } catch (Exception e) {
            log.error("avro 反序列化失败,错误信息: {}", e.getMessage(), e);
        }
    }
}
