package com.zorkdata.datamask.domain;

import lombok.Data;
import org.apache.hadoop.io.WritableComparable;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;

/**
 * @author wanghaiying
 * @Description 日志实体类
 * @Email wanghaiying@zork.com.cn
 * @Date 2020/9/25 10:00
 */
@Data
@SuppressWarnings("all")
public class LogData implements Serializable, WritableComparable {

    private static final long serialVersionUID = 1L;
    /**
     * logTypeName 日志类型
     */
    private String logTypeName;
    /**
     * timestamp 时间戳
     */
    private String timestamp;
    /**
     * 事件来源
     */
    private String source;
    /**
     * 偏移量
     */
    private String offset;
    /**
     * 维度
     */
    private Map<String, String> dimensions;
    /**
     * 指标
     */
    private Map<String, Double> measures;
    /**
     * 普通列
     */
    private Map<String, String> normalFields;

    @Override
    public int compareTo(Object o) {
        return 0;
    }

    @Override
    public void write(DataOutput dataOutput) throws IOException {
    }

    @Override
    public void readFields(DataInput dataInput) throws IOException {
    }
}
