package com.zorkdata.datamask.util;

import org.apache.flink.api.java.utils.ParameterTool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Map;

/**
 * @author 谢森
 * @Description 参数读取工具类
 * @Email xiesen@zork.com.cn
 */
public class ZorkParameterUtil {
    private static final Logger logger = LoggerFactory.getLogger(com.zorkdata.datamask.util.ZorkParameterUtil.class);
    public static final String YML_SUFFIX = "yml";

    /**
     * 读取参数
     *
     * @param args 参数名称
     *             这里默认使用 configPath 参数来标识配置文件的路径
     * @return
     */
    public static Map<String, String> readParameter(String[] args) {
        Map<String, String> conf = null;
        String configPath;
        try {
            ParameterTool parameterTool = ParameterTool.fromArgs(args);
            configPath = parameterTool.get("conf");
        } catch (Exception e) {
            throw new RuntimeException("读取配置文件失败,请检查配置路径.");
        }

        logger.info("read config path is " + configPath);

        if (!configPath.endsWith(YML_SUFFIX)) {
            System.err.println("Please input correct configuration file and flink run mode!");
            throw new RuntimeException("Please input correct configuration file and flink run mode!");
        } else {
            conf = LoadConf.loadYaml(configPath);
            if (conf == null) {
                logger.error("配置文件" + args[0] + "不存在,系统退出");
                throw new RuntimeException("配置文件" + args[0] + "不存在,系统退出");
            }
        }
        return conf;
    }
}
