package com.zorkdata.datamask.util;

import com.zorkdata.datamask.constant.ParamConstants;
import com.zorkdata.datamask.domain.HadoopParam;
import com.zorkdata.datamask.domain.KafkaParam;

import java.util.Map;

/**
 * @author 谢森
 * @Description 参数工具类
 * @Email xiesen310@163.com
 * @Date 2020/10/21 14:42
 */
public class ParamUtils {

    /**
     * 初始化配置文件
     *
     * @param conf
     */
    public static HadoopParam initHadoopConf(Map conf) {
        String source = String.valueOf(conf.get(ParamConstants.SOURCE)).trim();
        String hdfsSrc = String.valueOf(conf.get(ParamConstants.HDFS_SRC)).trim();
        String hdfsDest = String.valueOf(conf.get(ParamConstants.HDFS_DEST)).trim();
        String core = String.valueOf(conf.get(ParamConstants.CORE)).trim();
        String date = String.valueOf(conf.get(ParamConstants.DATE)).trim();
        Long startTime = Long.parseLong(String.valueOf(conf.get(ParamConstants.START_TIME)).trim());
        Long endTime = Long.parseLong(String.valueOf(conf.get(ParamConstants.END_TIME)).trim());
        return new HadoopParam(source, hdfsSrc, hdfsDest, core, date, startTime, endTime);
    }

    public static KafkaParam initKafkaConf(Map conf) {
        String servers = String.valueOf(conf.get(ParamConstants.SERVERS)).trim();
        String zookeeper = String.valueOf(conf.get(ParamConstants.ZOOKEEPER)).trim();
        String topic = String.valueOf(conf.get(ParamConstants.TOPIC)).trim();
        String hdfsDest = String.valueOf(conf.get(ParamConstants.HDFS_DEST)).trim();
        String core = String.valueOf(conf.get(ParamConstants.CORE)).trim();
        String date = String.valueOf(conf.get(ParamConstants.DATE)).trim();
        Long startTime = Long.parseLong(String.valueOf(conf.get(ParamConstants.START_TIME)).trim());
        Long endTime = Long.parseLong(String.valueOf(conf.get(ParamConstants.END_TIME)).trim());
        return new KafkaParam(servers, zookeeper, topic, hdfsDest, core, date, startTime, endTime);
    }
}
