import org.apache.hadoop.conf.Configuration;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.regex.Pattern;

/**
 * @author xiese
 * @Description 加载配置文件
 * @Email xiesen310@163.com
 * @Date 2020/10/15 13:13
 */
public class LoadConfig {
    private static final String SEPARATOR_SLASH = "/";

    /**
     * 读取配置文件
     *
     * @param yarnConfDir yarn 目录
     * @return
     * @throws Exception
     */
    public static Configuration getYarnConf(String yarnConfDir) throws Exception {
        Configuration yarnConf = new Configuration();
        try {
            File dir = new File(yarnConfDir);
            if (dir.exists() && dir.isDirectory()) {
                File[] xmlFileList = new File(yarnConfDir).listFiles((dir1, name) -> {
                    return name.endsWith(".xml");
                });
                if (xmlFileList != null) {
                    for (File xmlFile : xmlFileList) {
                        yarnConf.addResource(xmlFile.toURI().toURL());
                    }
                }
            }
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        return yarnConf;
    }
    
    public static Properties getProperties(String path) {
        Properties prop = new Properties();
        InputStream stream = null;
        try {
            stream = new FileInputStream(new File(getResourcePath(path)));
            prop.load(stream);
        } catch (IOException e) {
            System.err.println(String.format("读取 {} 配置文件失败", path));
            e.printStackTrace();
        } finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            } catch (Exception e) {
                System.err.println(String.format("读取配置文件 {} 失败", path));
                e.printStackTrace();
            }
        }
        return prop;
    }


    public static String getResourcePath(String name) {
        if (!SEPARATOR_SLASH.equals(File.separator)) {
            return name.replaceAll(Pattern.quote(File.separator), SEPARATOR_SLASH);
        }
        return name;
    }
}
