import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;

import java.io.IOException;

/**
 * @author xiese
 * @Description HadoopSecurityUtil HADOOP_USER_NAME=hdfs
 * @Email xiesen310@163.com
 * @Date 2020/10/15 11:35
 */
public class HadoopSecurityUtil {

    /**
     * keytab 文件
     */
    public static final String ZORK_KEYTAB_FILE_KEY = "keytab.file";

    /**
     * 票据  hdfs/cdh70150@ZORKDATA.COM
     */
    public static final String ZORK_KERBEROS_PRINCIPAL = "kerberos.principal";

    /**
     * krb5.conf 例如: "D:\\tmp\\tmp\\yarn-conf\\krb5.conf"
     */
    public static final String HADOOP_SECURITY_KRB_5_CONF = "hadoop.security.krb5.conf";

    /**
     * 用户名  hdfs
     */
    public static final String USER_NAME = "user.name";

    /**
     * yarn conf dir
     */
    public static final String YARN_CONF_DIR = "yarn.conf.dir";
    public static final String HADOOP_SECURITY_AUTHENTICATION = "hadoop.security.authentication";

    public static void login(Configuration kConfig) throws IOException {
        if (kConfig.get(ZORK_KEYTAB_FILE_KEY) == null || kConfig.get(ZORK_KERBEROS_PRINCIPAL) == null) {
            return;
        }

        System.setProperty("java.security.krb5.conf", kConfig.get(HADOOP_SECURITY_KRB_5_CONF));
        System.setProperty("HADOOP_USER_NAME", kConfig.get(USER_NAME));
        System.setProperty("user.name", kConfig.get(USER_NAME));
        kConfig.set(HADOOP_SECURITY_AUTHENTICATION, kConfig.get(HADOOP_SECURITY_AUTHENTICATION));
        UserGroupInformation.setConfiguration(kConfig);
        UserGroupInformation.loginUserFromKeytab(kConfig.get(ZORK_KERBEROS_PRINCIPAL), kConfig.get(ZORK_KEYTAB_FILE_KEY));
    }
}