import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.NodeReport;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.YarnClusterMetrics;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.exceptions.YarnException;

import java.io.IOException;
import java.util.List;
import java.util.Properties;

/**
 * @author xiese
 * @Description FlinkYarnHaTest
 * @Email xiesen310@163.com
 * @Date 2020/10/14 19:19
 */
public class FlinkYarnHaTest {

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.err.println("parameters missing. please enter configuration file (参数缺失,请输入配置文件)");
            throw new RuntimeException("parameters missing. please enter configuration file (参数缺失,请输入配置文件)");
        }

        Properties prop = LoadConfig.getProperties(args[0]);
        String yarnConfDir = prop.getProperty(HadoopSecurityUtil.YARN_CONF_DIR);
        String keytabFile = prop.getProperty(HadoopSecurityUtil.ZORK_KEYTAB_FILE_KEY);
        String kerberosPrincipal = prop.getProperty(HadoopSecurityUtil.ZORK_KERBEROS_PRINCIPAL);
        String krb5Conf = prop.getProperty(HadoopSecurityUtil.HADOOP_SECURITY_KRB_5_CONF);
        String username = prop.getProperty(HadoopSecurityUtil.USER_NAME);
        String authentication = prop.getProperty(HadoopSecurityUtil.HADOOP_SECURITY_AUTHENTICATION);

        if (!ParamUtil.check(yarnConfDir, keytabFile, kerberosPrincipal, krb5Conf, username)) {
            throw new RuntimeException(String.format("(Please check the parameters) 请检查参数 [{ " + HadoopSecurityUtil.YARN_CONF_DIR
                    + " }],[{ " + HadoopSecurityUtil.ZORK_KEYTAB_FILE_KEY
                    + " }],[{ " + HadoopSecurityUtil.ZORK_KERBEROS_PRINCIPAL
                    + " }],[{ " + HadoopSecurityUtil.HADOOP_SECURITY_KRB_5_CONF
                    + " }],[{ " + HadoopSecurityUtil.USER_NAME
                    + " }],[{" + HadoopSecurityUtil.HADOOP_SECURITY_AUTHENTICATION + "}]"
            ));
        }


        Configuration yarnConf = LoadConfig.getYarnConf(yarnConfDir);

        yarnConf.set(HadoopSecurityUtil.ZORK_KEYTAB_FILE_KEY, keytabFile);
        yarnConf.set(HadoopSecurityUtil.ZORK_KERBEROS_PRINCIPAL, kerberosPrincipal);
        yarnConf.set(HadoopSecurityUtil.HADOOP_SECURITY_KRB_5_CONF, krb5Conf);
        yarnConf.set(HadoopSecurityUtil.USER_NAME, username);
        yarnConf.set(HadoopSecurityUtil.HADOOP_SECURITY_AUTHENTICATION, authentication);

        HadoopSecurityUtil.login(yarnConf);
        getYarnClusterInfo(yarnConf);

    }

    /**
     * 获取 yarn 集群信息
     *
     * @param yarnConf
     * @throws YarnException
     * @throws IOException
     */
    private static void getYarnClusterInfo(Configuration yarnConf) throws YarnException, IOException {
        /// 创建 yarn Client 和 resource manager 进行交互
        YarnClient yarnClient = YarnClient.createYarnClient();
        yarnClient.init(yarnConf);

        /// yarnClient需要启动之后才能用
        yarnClient.start();

        /// 获取集群信息
        YarnClusterMetrics clusterMetrics = yarnClient.getYarnClusterMetrics();

        ///  获取各节点的运行状态
        List<NodeReport> clusterNodeReports = yarnClient.getNodeReports(NodeState.RUNNING);
        clusterNodeReports.forEach((node) -> System.out.println("Node information (节点信息): " + node));

        ///  获取集群所有队列
        List<QueueInfo> allQueues = yarnClient.getAllQueues();

        allQueues.forEach((queue) -> System.err.println("Cluster queue (集群队列): " + queue));
    }
}
