package com.zorkdata.datamask.util;

import com.zorkdata.datamask.constant.ParamConstants;
import com.zorkdata.datamask.constant.RegExpConstants;
import com.zorkdata.datamask.domain.HdfsLogQueryParam;
import com.zorkdata.datamask.domain.KafkaMsgQueryParam;

import java.util.HashMap;
import java.util.Map;

/**
 * @author 谢森
 * @Description 参数工具类
 * @Email xiesen310@163.com
 * @Date 2020/10/21 14:42
 */
public class ParamUtils {

    /**
     * 初始化配置文件
     *
     * @param conf
     */
    public static HdfsLogQueryParam initHadoopConf(Map conf) {
        String source = String.valueOf(conf.get(ParamConstants.SOURCE)).trim();
        String hdfsSrc = String.valueOf(conf.get(ParamConstants.HDFS_SRC)).trim();
        String hdfsDest = String.valueOf(conf.get(ParamConstants.HDFS_DEST)).trim();
        String core = String.valueOf(conf.get(ParamConstants.CORE)).trim();
        String date = String.valueOf(conf.get(ParamConstants.DATE)).trim();
        Long startTime = Long.parseLong(String.valueOf(conf.get(ParamConstants.START_TIME)).trim());
        Long endTime = Long.parseLong(String.valueOf(conf.get(ParamConstants.END_TIME)).trim());
        return new HdfsLogQueryParam(source, hdfsSrc, hdfsDest, core, date, startTime, endTime);
    }

    public static KafkaMsgQueryParam initKafkaConf(Map conf) {
        String servers = String.valueOf(conf.get(ParamConstants.SERVERS)).trim();
        String zookeeper = String.valueOf(conf.get(ParamConstants.ZOOKEEPER)).trim();
        String topic = String.valueOf(conf.get(ParamConstants.TOPIC)).trim();
        String hdfsDest = String.valueOf(conf.get(ParamConstants.HDFS_DEST)).trim();
        String core = String.valueOf(conf.get(ParamConstants.CORE)).trim();
        String date = String.valueOf(conf.get(ParamConstants.DATE)).trim();
        Long startTime = Long.parseLong(String.valueOf(conf.get(ParamConstants.START_TIME)).trim());
        Long endTime = Long.parseLong(String.valueOf(conf.get(ParamConstants.END_TIME)).trim());
        return new KafkaMsgQueryParam(servers, zookeeper, topic, hdfsDest, core, date, startTime, endTime);
    }

    public static MaskUtil initMaskUtil(Map conf) {
        Map regularExpressions = (HashMap)conf.get(RegExpConstants.REG_EXP);

        String nameRegExp = String.valueOf(regularExpressions.get(RegExpConstants.NAME_REG_EXP)).trim();
        String mobileRegExp = String.valueOf(regularExpressions.get(RegExpConstants.MOBILE_REG_EXP)).trim();
        String phoneRegExp = String.valueOf(regularExpressions.get(RegExpConstants.PHONE_REG_EXP)).trim();
        String emailRegExp = String.valueOf(regularExpressions.get(RegExpConstants.EMAIL_REG_EXP)).trim();
        String idRegExp15 = String.valueOf(regularExpressions.get(RegExpConstants.ID15_REG_EXP)).trim();
        String idRegExp18 = String.valueOf(regularExpressions.get(RegExpConstants.ID18_REG_EXP)).trim();
        String bankCardRegExp = String.valueOf(regularExpressions.get(RegExpConstants.BANK_CARD_REG_EXP)).trim();
        String addressRegExp = String.valueOf(regularExpressions.get(RegExpConstants.ADDRESS_REG_EXP)).trim();
        String ipRegExp = String.valueOf(regularExpressions.get(RegExpConstants.IP_REG_EXP)).trim();
        String macRegExp = String.valueOf(regularExpressions.get(RegExpConstants.MAC_REG_EXP)).trim();
        return new MaskUtil(nameRegExp, mobileRegExp, phoneRegExp, emailRegExp, idRegExp15, idRegExp18, bankCardRegExp, addressRegExp, ipRegExp, macRegExp);
    }
}
