package com.zorkdata.datamask.util;

import java.io.Serializable;
import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * Description:
 *
 * @author: wanghaiying (<a href="wanghaiying@zorkdata.com.cn">wanghaiying@zorkdata.com.cn</a>)
 * Date: Create in 2020/9/23 9:30
 */
public class MaskUtil implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final int DEFAULT_MAP_CAPACITY = 16;

    /**
     * 姓名正则
     */
    private String nameRegExp;

    /**
     * 手机号正则
     */
    private String mobileRegExp;

    /**
     * 电话号码正则
     */
    private String phoneRegExp;

    /**
     * 邮箱正则
     */
    private String emailRegExp;

    /**
     * 身份证号码（15位）正则
     */
    private String idRegExp15;

    /**
     * 身份证号码（18位）正则
     */
    private String idRegExp18;

    /**
     * 银行卡号码正则
     */
    private String bankCardRegExp;

    /**
     * 家庭住址正则
     */
    private String addressRegExp;

    /**
     * ip地址正则
     */
    private String ipRegExp;

    /**
     * mac地址正则
     */
    private String macRegExp;

    List<Pattern> patterns = new ArrayList<Pattern>() {{
    }};

    public MaskUtil(String nameRegExp, String mobileRegExp, String phoneRegExp, String emailRegExp, String idRegExp15, String idRegExp18, String bankCardRegExp, String addressRegExp, String ipRegExp, String macRegExp) {
        this.nameRegExp = nameRegExp;
        this.mobileRegExp = mobileRegExp;
        this.phoneRegExp = phoneRegExp;
        this.emailRegExp = emailRegExp;
        this.idRegExp15 = idRegExp15;
        this.idRegExp18 = idRegExp18;
        this.bankCardRegExp = bankCardRegExp;
        this.addressRegExp = addressRegExp;
        this.ipRegExp = ipRegExp;
        this.macRegExp = macRegExp;
    }

    public Map mask(Map map, ArrayList whiteList) {
        patterns.add(Pattern.compile(this.nameRegExp));
        patterns.add(Pattern.compile(this.macRegExp));
        patterns.add(Pattern.compile(this.emailRegExp));
        patterns.add(Pattern.compile(this.ipRegExp));
        patterns.add(Pattern.compile(this.nameRegExp));
        patterns.add(Pattern.compile(this.idRegExp18));
        patterns.add(Pattern.compile(this.idRegExp15));
        patterns.add(Pattern.compile(this.bankCardRegExp));
        patterns.add(Pattern.compile(this.mobileRegExp));
        patterns.add(Pattern.compile(this.phoneRegExp));
        patterns.add(Pattern.compile(this.addressRegExp));

        map.forEach((k, v) -> {
            if (!whiteList.contains(k)) {
                String value = v.toString();
                for (Pattern pattern : patterns) {
                    Matcher matcher = pattern.matcher(value);
                    if (matcher.find()) {
                        String replaceStr = "";
                        for (int i = 0; i < matcher.group().length(); i++) {
                            replaceStr = replaceStr.concat("*");
                        }
                        value = value.replace(matcher.group(), replaceStr);
                    }
                }
                map.put(k, value);
            } else {
                map.put(k, v);
            }
        });
        return map;
    }

    public static void main(String[] args) {
        MaskUtil maskUtil = new MaskUtil("[\\u4e00-\\u9fa5]{1,20}|[a-zA-Z\\\\.\\\\s]{1,20}", "((13[0-9])|(14[5,7])|(15[0-3,5-9])|(17[0,3,5-8])|(18[0-9])|(147))\\d{8}",
                "(\\d{3,4}-)?\\d{6,8}", "\\w+([-+.]\\w+)*@\\w+([-.]\\w+)*\\.\\w+([-.]\\w+)*", "[1-9]\\d{7}((0\\d)|(1[0-2]))(([0|1|2]\\d)|3[0-1])\\d{3}",
                "[1-9]\\d{5}[1-9]\\d{3}((0\\d)|(1[0-2]))(([0|1|2]\\d)|3[0-1])\\d{3}([0-9Xx])", "([1-9]{1})(\\d{11}|\\d{15}|\\d{16}|\\d{17}|\\d{18})",
                "([\u4E00-\u9FA5A-Za-z0-9_]+(省|市|区|县|道|路|街|号|弄|条|室)){2,}", "((2[0-4]\\d|25[0-5]|[01]?\\d\\d?)\\.){3}(2[0-4]\\d|25[0-5]|[01]?\\d\\d?)",
                "([A-Fa-f0-9]{2}-){5}[A-Fa-f0-9]{2}");

        Map map = new HashMap(DEFAULT_MAP_CAPACITY);
        map.put("姓名", "王海鹰");
        map.put("身份证号", "372925199008075158");
        map.put("手机号", "15000101879");
        map.put("电话", "021-61341606");
        map.put("邮箱", "wanghaiying@zork.com");
        map.put("住址", "上海市浦东新区碧波路690号1弄");
        map.put("住址2", "上海市浦东新区张江微电子港304-2室");
        map.put("ip地址", "192.168.70.2");
        map.put("mac地址", "3c-78-43-25-80-bd");
        map.put("message", "王海鹰,372925199008075158#15000101879");
        map.put("messid", "0000011404342B32233DDCDA");
        map.put("bsflag", "0000011404342B32233DDCDA");
        map.put("normalFields", "13811110000-110101199003075517-上海市浦东新区张江微电子港-zorkdata@163.com-123456789-wanghaiying123-王海鹰-192.168.1.1-00-50-56-C0-00-08-6227002470170278192");

        String[] fieldsWhiteListArray = "messid,fundid,custid,orgid,brhid,secuid,bankcode,market,ordersno,ordergroup,count,poststr,stkcode,bsflag,orderamt,price,qty,bankcode,tacode,ofcode,transacc,taacc".split(",");

        ArrayList< String> fieldsWhiteList = new ArrayList<String>(fieldsWhiteListArray.length);
        Collections.addAll(fieldsWhiteList, fieldsWhiteListArray);

        System.out.println(maskUtil.mask(map, fieldsWhiteList));
    }
}
