package com.zorkdata.datamask;

import com.alibaba.fastjson.JSON;
import com.zorkdata.datamask.constant.ParamConstants;
import com.zorkdata.datamask.hadoop.HdfsLogMaskUtil;
import com.zorkdata.datamask.kafka.KafkaMsgMaskUtil;
import com.zorkdata.datamask.util.ZorkParameterUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;

/**
 * Description : 国泰交易日志脱敏job
 *
 * @author : wanghaiying (<a href="wanghaiying@zorkdata.com.cn">wanghaiying@zorkdata.com.cn</a>)
 * Date : Create in 2020/9/18 17:35
 */
public class TransactionLogMask {
    private static Logger logger = LoggerFactory.getLogger(TransactionLogMask.class);
    public static final int PARAM_LENGTH = 2;

    public static void main(String[] args) throws Exception {

        if (args.length != PARAM_LENGTH) {
            String error = "参数缺失,请输入配置文件,例如: --conf /opt/TransactionLogMask/application.yml";
            logger.error(error);
            throw new RuntimeException(error);
        }
        Map<String, String> conf = ZorkParameterUtil.readParameter(args);
        logger.info("配置文件: {}", JSON.toJSONString(conf));
        String source = conf.get(ParamConstants.SOURCE);

        if (ParamConstants.HDFS.equals(source)) {
            HdfsLogMaskUtil.maskHdfsLog(conf);
        } else if (ParamConstants.KAFKA.equals(source)) {
            KafkaMsgMaskUtil.maskKafkaMsg(conf);
        }
    }

}
