package com.zorkdata.datamask.domain;

import lombok.Data;

import java.io.Serializable;

/**
 * @author 谢森
 * @Description kafka 参数实体类
 * @Email xiesen310@163.com
 * @Date 2020/10/21 15:07
 */
@Data
public class KafkaMsgQueryParam implements Serializable {

    private static final long serialVersionUID = 1L;

    private String servers;
    private String zookeeper;
    private String topic;
    private String hdfsDest;
    private String core;
    private String date;
    private Long startTime;
    private Long endTime;

    public KafkaMsgQueryParam(String servers, String zookeeper, String topic, String hdfsDest, String core, String date,
                              Long startTime, Long endTime) {
        this.servers = servers;
        this.zookeeper = zookeeper;
        this.topic = topic;
        this.hdfsDest = hdfsDest;
        this.core = core;
        this.date = date;
        this.startTime = startTime;
        this.endTime = endTime;
    }
}
