package com.zorkdata.datamask.util;

import org.apache.flink.api.java.utils.ParameterTool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Map;

/**
 * @author 谢森
 * @Description 参数读取工具类
 * @Email xiesen@zork.com.cn
 */
public class ZorkParameterUtil {
    private static final Logger logger = LoggerFactory.getLogger(com.zorkdata.datamask.util.ZorkParameterUtil.class);

    /**
     * 读取参数
     *
     * @param args 参数名称
     *             这里默认使用 configPath 参数来标识配置文件的路径
     * @return
     */
    public static Map<String, String> readParameter(String[] args) {
        Map<String, String> conf = null;
        String configPath;
        try {
            ParameterTool parameterTool = ParameterTool.fromArgs(args);
            configPath = parameterTool.get("configPath");
        } catch (Exception e) {
//            configPath = "/etc/flinkConfig.yaml";
            configPath = "D:\\zork\\transactionLogMask\\src\\main\\resources\\application.yml";
        }

        logger.info("read config path is " + configPath);

        if (!configPath.endsWith("yaml")) {
            System.err.println("Please input correct configuration file and flink run mode!");
            System.exit(-1);
        } else {
            conf = LoadConf.LoadYaml(configPath);
            if (conf == null) {
                logger.error("配置文件" + args[0] + "不存在,系统退出");
                System.exit(-1);
            }
        }
        return conf;
    }
}
