package com.zorkdata.datamask.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * Description :
 *
 * @author : wanghaiying (<a href="wanghaiying@zorkdata.com.cn">wanghaiying@zorkdata.com.cn</a>)
 * Date : Create in 2020/9/23 9:30
 * RegularExpression
 */
public class MaskUtil {

    /**
     * 姓名正则
     */
    static Pattern namePattern = Pattern.compile("^([\\u4e00-\u9fa5]{1,20}|[a-zA-Z\\.\\s]{1,20})$");
    /**
     * 手机号正则
     */
    static Pattern mobilePattern = Pattern.compile("^((13[0-9])|(14[5,7])|(15[0-3,5-9])|(17[0,3,5-8])|(18[0-9])|(147))\\d{8}$");
    /**
     * 电话号码正则
     */
    static Pattern phonePattern = Pattern.compile("^(\\d{3,4}-)?\\d{6,8}$");
    /**
     * 邮箱正则
     */
    static Pattern emailPattern = Pattern.compile("^\\w+([-+.]\\w+)*@\\w+([-.]\\w+)*\\.\\w+([-.]\\w+)*$");
    /**
     * 身份证号码（15位）正则
     */
//    static Pattern idPattern15 = Pattern.compile("\\d{17}[0-9Xx]|\\d{15}");
    static Pattern idPattern15 = Pattern.compile("^[1-9]\\d{7}((0\\d)|(1[0-2]))(([0|1|2]\\d)|3[0-1])\\d{3}$");
    /**
     * 身份证号码（18位）正则
     */
    static Pattern idPattern18 = Pattern.compile("^[1-9]\\d{5}[1-9]\\d{3}((0\\d)|(1[0-2]))(([0|1|2]\\d)|3[0-1])\\d{3}([0-9Xx])$");
    /**
     * 家庭住址正则
     */
    static Pattern addressPattern = Pattern.compile("^([\\u4E00-\\u9FA5A-Za-z0-9_]+(省|市|区|县|道|路|街|号)){2,}$");
    /**
     * ip地址正则
     */
//    static Pattern ipPattern = Pattern.compile("^((\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5]|[*])\\.){3}(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5]|[*])$");
    static Pattern ipPattern = Pattern.compile("((2[0-4]\\d|25[0-5]|[01]?\\d\\d?)\\.){3}(2[0-4]\\d|25[0-5]|[01]?\\d\\d?)");

    static Pattern macPattern = Pattern.compile("([A-Fa-f0-9]{2}-){5}[A-Fa-f0-9]{2}");

    static List<Pattern> patterns = new ArrayList<Pattern>(){{
        add(namePattern);
        add(mobilePattern);
        add(phonePattern);
        add(emailPattern);
        add(idPattern15);
        add(idPattern18);
        add(addressPattern);
        add(ipPattern);
        add(macPattern);
    }};

    public static Map mask(Map map){
        map.forEach((k, v) -> {
            String value = v.toString();
            for(Pattern pattern:patterns){
                Matcher matcher = pattern.matcher(v.toString());
                if (matcher.matches()){
                    String replaceStr = "";
                    for(int i=0; i < matcher.group().length(); i++){
                        replaceStr = replaceStr.concat("*");
                    }
//                    System.out.println(replaceStr);
                    value = value.replace(matcher.group(), replaceStr);
                }
            }
            map.put(k, value);
        });
        return map;
    }

    public static void main(String[] args) {
        Map map = new HashMap();
        map.put("姓名", "王海鹰");
        map.put("身份证号", "372925199008075158");
        map.put("手机号", "15000101879");
        map.put("电话", "021-61341606");
        map.put("邮箱", "wanghaiying@zork.com.cn");
        map.put("住址", "上海市浦东新区碧波路690号");
        map.put("ip地址", "192.168.70.2");
        map.put("mac地址", "3c-78-43-25-80-bd");
        System.out.println(mask(map));

//        String mobile = "15000101879";
//
//        Pattern pattern = Pattern.compile("(13\\d|14[579]|15[^4\\D]|17[^49\\D]|18\\d)\\d{8}");
//        Matcher m = pattern.matcher(mobile);
////
//        System.out.println(m.matches());
//        if(m.matches()){
//            System.out.println(m.group());
//
//            String replaceStr = "";
//            for(int i=0; i < m.group().length(); i++){
//                replaceStr = replaceStr.concat("*");
//            }
//            System.out.println(replaceStr);
//            mobile = mobile.replaceAll(m.group(), replaceStr);
//            System.out.println(mobile);
//        }
    }
}
