package com.zorkdata.tools.mock.ruleScopeMetric;

import com.zorkdata.tools.avro.AvroSerializer;
import com.zorkdata.tools.avro.AvroSerializerFactory;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.serialization.ByteArraySerializer;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

/**
 * @author DeleMing
 */
public class MetricYf121JiChuJianKongCLuster {
    private static String topic = "dwd_all_metric";
    private static String brokerAddr = "node1:9092,node2:9092,node3:9092";
//    private static String brokerAddr = "autotest-1:9092,autotest-2:9092,autotest-3:9092";
//    private static String brokerAddr = "noahtest-215:9092,noahtest-216:9092,noahtest-217:9092";
//    private static String brokerAddr = "yf170:9092,yf171:9092,yf172:9092";
//    private static String brokerAddr = "localhost:9092";
    private static ProducerRecord<String, byte[]> producerRecord = null;
    private static KafkaProducer<String, byte[]> producer = null;

    public static void init() {
        Properties props = new Properties();
        props.put("bootstrap.servers", brokerAddr);
        props.put("acks", "1");
        props.put("retries", 0);
        props.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        props.put("value.serializer", ByteArraySerializer.class.getName());
        props.put("batch.size", 16384);
        props.put("linger.ms", 1);
        props.put("buffer.memory", 33554432);
        producer = new KafkaProducer<String, byte[]>(props);
    }

    public static void main(String[] args) throws InterruptedException {
        init();

        //MetricSet
        String metricSetName = "cpu_system_mb";

        //Dimensions
        Map<String, String> dimensions = new HashMap<>();
        dimensions.put("appsystem", "dev_test");
        dimensions.put("clustername", "基础监控");
        dimensions.put("appprogramname", "linux模块");
        dimensions.put("hostname", "yf121");
        dimensions.put("ip", "192.168.70.121");

        for (int i = 0; i <= 30000; i++) {

            //MetricItem
            Map<String, Double> metrics = new HashMap<>();
            metrics.put("user_pct", 0.1);

            //timestamp
            long timestamp = System.currentTimeMillis();
            String timestampString = String.valueOf(timestamp);
            System.out.println("时间："+timestampString);
            //AvroSerializer
            AvroSerializer metricSerializer = AvroSerializerFactory.getMetricAvroSerializer();
            byte[] bytes = metricSerializer.serializingMetric(metricSetName, timestampString, dimensions, metrics);

            //send
            producerRecord = new ProducerRecord<String, byte[]>(topic, null, bytes);
            producer.send(producerRecord);
            Thread.sleep(10000); // 210/210=1 信息
        }
    }
}


