package com.zorkdata.tools.mock.SystemIndex;

import com.alibaba.fastjson.JSONObject;
import com.zorkdata.tools.kafka.Producer;
import com.zorkdata.tools.kafka.ProducerPool;
import com.zorkdata.tools.utils.DateUtil;
import com.zorkdata.tools.utils.PropertiesUtil;
import com.zorkdata.tools.utils.StringUtil;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Random;

public class MockLogSI_Alarm_zork90_10 {

    public static String printData(String logTypeName, String timestamp, String source, String offset,
                                   Map<String, String> dimensions, Map<String, Double> metrics, Map<String, String> normalFields) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("logTypeName", logTypeName);
        jsonObject.put("timestamp", timestamp);
        jsonObject.put("source", source);
        jsonObject.put("offset", offset);
        jsonObject.put("dimensions", dimensions);
        jsonObject.put("measures", metrics);
        jsonObject.put("normalFields", normalFields);
        return jsonObject.toString();
    }

    private static String getRandomOffset() {
        Random random = new Random();
        long l = random.nextInt(10000);
        return String.valueOf(l);
    }

    private static Map<String, String> getRandomDimensions() {
        Random random = new Random();
        int i = random.nextInt(10);
        Map<String, String> dimensions = new HashMap<>();
        dimensions.put("appsystem", "alarm");
        dimensions.put("clustername", "告警集群");
        dimensions.put("appprogramname", "告警模块1");
        dimensions.put("hostname", "zork90-10");
        dimensions.put("ip", "192.168.90.10");
        return dimensions;
    }

    private static Map<String, String> getRandomNormalFieldsError() {
        Map<String, String> normalFields = new HashMap<>(5);
        normalFields.put("message", "qqt_alarm_index_message");
        return normalFields;
    }

    public static void main(String[] args) throws Exception {
        long size = 30000;
        for (int i = 0; i < size; i++) {
            if (i != 0) {
                Thread.sleep(5000);
            }
            String logTypeName = "default_analysis_template";
            String timestamp = DateUtil.getUTCTimeStr();
            System.out.println("timestamp====="+timestamp);
            String source = "/var/log/test.log";
            String offset = getRandomOffset();
            Map<String, String> dimensions = getRandomDimensions();
            Map<String, Double> measures = new HashMap<>();
            Map<String, String> normalFields = getRandomNormalFieldsError();
            Producer producer = ProducerPool.getInstance().getProducer();
            producer.sendLog("dwd_default_log", logTypeName, timestamp, source, offset, dimensions, measures, normalFields);
        }

    }
}
