package com.zorkdata.tools.mock;

import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import com.zorkdata.tools.avro.AvroSerializer;
import com.zorkdata.tools.avro.AvroSerializerFactory;
import org.joda.time.DateTime;

import java.util.*;

/**
 * @author DeleMing
 */
public class MockZorkMetricAfter15Seconds {
    //    private static String topic = "alert_test_source";
    private static String topic = "dwd_all_metric";
    private static String brokerAddr = "node1:9092,node2:9092,node3:9092";
    private static ProducerRecord<String, byte[]> producerRecord = null;
    private static KafkaProducer<String, byte[]> producer = null;

    public static void init() {
        Properties props = new Properties();
        props.put("bootstrap.servers", brokerAddr);
        props.put("acks", "1");
        props.put("retries", 0);
        props.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        props.put("value.serializer", ByteArraySerializer.class.getName());
        props.put("batch.size", 16384);
        props.put("linger.ms", 1);
        props.put("buffer.memory", 33554432);
        producer = new KafkaProducer<String, byte[]>(props);
    }

    public static byte[] buildMetric() {
        Random random = new Random();
        String metricSetName = "cpu_system_mb";

        //往前对齐15s
//        DateTime timeNow = new DateTime();
//        int minute = timeNow.getSecondOfMinute()/15*15;
//        DateTime timeStart = new DateTime(timeNow.getYear(),timeNow.getMonthOfYear(),timeNow.getDayOfMonth(),timeNow.getHourOfDay(), timeNow.getMinuteOfHour(),minute,000);
//        long millis = timeStart.getMillis();
//        String timestamp = String.valueOf(millis);

        //往后对齐15s === start
//        DateTime timeNow = new DateTime();
//        System.out.println("true time: "+timeNow);
//        int seconds = timeNow.getSecondOfMinute();
//        int minute = timeNow.getMinuteOfHour();
//        int round = seconds/15;
//        //往后对齐15s
//        if (round < 3){
//            seconds = round * 15+15;
//        }else if (round == 3){
//            minute += 1;
//            seconds = 0;
//        }
//        DateTime timeStart = new DateTime(timeNow.getYear(),timeNow.getMonthOfYear(),timeNow.getDayOfMonth(),timeNow.getHourOfDay(), minute, seconds,000);
//
//        System.out.println("modified time: "+timeStart);
//        long millis = timeStart.getMillis();
//        String timestamp = String.valueOf(millis);
        //往后对齐15s === start

        DateTime timeNow = new DateTime();
        long millis = timeNow.getMillis();
        String timestamp = String.valueOf(millis);

        Map<String, String> dimensions = new HashMap<>();

        dimensions.put("appsystem", "dev_test");
        dimensions.put("cluster", "基础监控");
        dimensions.put("module", "ShanDong");
        dimensions.put("hostname", "node1");
        dimensions.put("ip", "192.168.70.212");

        Map<String, Double> metrics = new HashMap<>();
        metrics.put("user_pct", 0.7);

        AvroSerializer metricSerializer = AvroSerializerFactory.getMetricAvroSerializer();
        byte[] bytes = metricSerializer.serializingMetric(metricSetName, timestamp, dimensions, metrics);
        return bytes;
    }

    public static void send(String topic) {
        init();
        byte[] req = buildMetric();
        producerRecord = new ProducerRecord<String, byte[]>(
                topic,
                null,
                req
        );
        producer.send(producerRecord);
    }


    public static void main(String[] args) throws InterruptedException {
        for (int i = 0; i <= 30000; i++) {
            send(topic);
            Thread.sleep(10000);
        }
    }
}


