package com.zorkdata.tools.mock;

import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import com.zorkdata.tools.avro.AvroSerializer;
import com.zorkdata.tools.avro.AvroSerializerFactory;
import org.joda.time.DateTime;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Random;

/**
 * @author DeleMing
 */
public class MockZorkMetric {
    private static String topic = "dwd_all_metric";
    private static String brokerAddr = "node1:9092,node2:9092,node3:9092";
    private static ProducerRecord<String, byte[]> producerRecord = null;
    private static KafkaProducer<String, byte[]> producer = null;

    public static void init() {
        Properties props = new Properties();
        props.put("bootstrap.servers", brokerAddr);
        props.put("acks", "1");
        props.put("retries", 0);
        props.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        props.put("value.serializer", ByteArraySerializer.class.getName());
        props.put("batch.size", 16384);
        props.put("linger.ms", 1);
        props.put("buffer.memory", 33554432);
        producer = new KafkaProducer<String, byte[]>(props);
    }

    public static byte[] buildMetric() {
        Random random = new Random();
        String metricSetName = "cpu_system_mb";
        DateTime timeNow = new DateTime();
        int minute = timeNow.getSecondOfMinute()/15*15;
        DateTime timeStart = new DateTime(timeNow.getYear(),timeNow.getMonthOfYear(),timeNow.getDayOfMonth(),timeNow.getHourOfDay(), timeNow.getMinuteOfHour(),minute,000);

        String timestamp = timeStart.toString();
        Map<String, String> dimensions = new HashMap<>();
        dimensions.put("hostname", "node1");
        dimensions.put("appsystem", "dev_test");

        Map<String, Double> metrics = new HashMap<>();
        metrics.put("used_pct", 0.5);

        AvroSerializer metricSerializer = AvroSerializerFactory.getMetricAvroSerializer();
        byte[] bytes = metricSerializer.serializingMetric(metricSetName, timestamp, dimensions, metrics);
        return bytes;
    }

    public static void send(String topic) {
        init();
        byte[] req = buildMetric();
        producerRecord = new ProducerRecord<String, byte[]>(
                topic,
                "",
                req
        );
        producer.send(producerRecord);
    }


    public static void main(String[] args) throws InterruptedException {
        for (int i = 0; i <= 300; i++) {
            send(topic);
            Thread.sleep(15000);
        }
    }
}
