package com.zorkdata.tools.mock;

import com.zorkdata.tools.avro.AvroSerializer;
import com.zorkdata.tools.avro.AvroSerializerFactory;
import lombok.extern.slf4j.Slf4j;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.joda.time.DateTime;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Random;

/**
 * @author DeleMing
 */
@Slf4j
public class MockStreamxMetricAvro {
    private static String topic = "alert_test_source_001";
//    private static String brokerAddr = "kafka-1:19092,kafka-2:19092,kafka-3:19092";
//    private static String brokerAddr = "yf122:9092,yf121:9092,yf120:9092";
    private static String brokerAddr = "autotest-3:9092,autotest-2:9092,autotest-1:9092";
    private static ProducerRecord<String, byte[]> producerRecord = null;
    private static KafkaProducer<String, byte[]> producer = null;
    private static DateTime timeStart;

    public static void init() {
        Properties props = new Properties();
        props.put("bootstrap.servers", brokerAddr);
        props.put("acks", "1");
        props.put("retries", 0);
        props.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        props.put("value.serializer", ByteArraySerializer.class.getName());
        props.put("batch.size", 16384);
        props.put("linger.ms", 1);
        props.put("buffer.memory", 33554432);
        producer = new KafkaProducer<String, byte[]>(props);
    }

    public static byte[] buildMetric(double userPct) {
        String metricSetName = "cpu_system_mb";
//        String timestamp = timeStart.toString();
        String timestamp = String.valueOf(timeStart.getMillis());
        Map<String, String> dimensions = new HashMap<>();

        dimensions.put("hostname", "yf120");//"zorkdata" + i);
        dimensions.put("ip", "192.168.70.120");
        dimensions.put("appsystem", "dev_test");
        dimensions.put("cluster", "基础监控");
        dimensions.put("module", "lmt模块");

        Map<String, Double> metrics = new HashMap<>();
        metrics.put("user_pct", userPct);

        AvroSerializer metricSerializer = AvroSerializerFactory.getMetricAvroSerializer();
        byte[] bytes = metricSerializer.serializingMetric(metricSetName, timestamp, dimensions, metrics);
        return bytes;
    }
    public static byte[] buildMetric2(double userPct) {
        String metricSetName = "cpu_system_mb";
        String timestamp = String.valueOf(timeStart.getMillis());
//        String timestamp = timeStart.toString();

        Map<String, String> dimensions = new HashMap<>();

        dimensions.put("hostname", "yf121");//"zorkdata" + i);
        dimensions.put("ip", "192.168.70.121");
        dimensions.put("appsystem", "dev_test");
        dimensions.put("cluster", "基础监控");
        dimensions.put("module", "lmt模块");

        Map<String, Double> metrics = new HashMap<>();
        metrics.put("user_pct", userPct);

        AvroSerializer metricSerializer = AvroSerializerFactory.getMetricAvroSerializer();
        byte[] bytes = metricSerializer.serializingMetric(metricSetName, timestamp, dimensions, metrics);
        return bytes;
    }
    public static void send(String topic,double userPct) {
        byte[] req = buildMetric(userPct);
        producerRecord = new ProducerRecord<String, byte[]>(
                topic,
                "",
                req
        );
        producer.send(producerRecord);
    }
    public static void send2(String topic,double userPct) {
        byte[] req = buildMetric2(userPct);
        producerRecord = new ProducerRecord<String, byte[]>(
                topic,
                "",
                req
        );
        producer.send(producerRecord);
    }

    public static void main(String[] args) throws InterruptedException {
        init();
        DateTime timeNow = new DateTime();
        //时间往前对齐，15s。比如当前时间是21:22:17, 则时间取值为21:22:15
        int minute = timeNow.getSecondOfMinute()/15*15;
        timeStart = new DateTime(timeNow.getYear(),timeNow.getMonthOfYear(),timeNow.getDayOfMonth(),timeNow.getHourOfDay(), timeNow.getMinuteOfHour(),minute,000);

        for (int i = 0; i <= 30000; i++) {
            if (i != 0) {
                //15s发一次数据
                Thread.sleep(15000);
            }

            //当时间为0, 2, 8, 13发送，具体的看一下那个测试用例Excel
//            int cycle = i%16;
//            if (cycle==0||cycle==13) {
//                send(topic,1);
//                send2(topic,1);
//                log.info(timeStart+"=>1");
//            }else if (cycle==2||cycle==8) {
//                send(topic,0.3);
//                send2(topic,0.3);
//                log.info(timeStart+"=>0.3");
//            }

            int cycle = i%20;
            if (cycle<=11) {
                send(topic,0.5);
            }

            timeStart = timeStart.plusSeconds(15);
        }
    }
}
