package com.zorkdata.tools.mock;

import com.alibaba.fastjson.JSONObject;
import com.zorkdata.tools.kafka.Producer;
import com.zorkdata.tools.kafka.ProducerPool;
import com.zorkdata.tools.utils.DateUtil;
import com.zorkdata.tools.utils.PropertiesUtil;
import com.zorkdata.tools.utils.StringUtil;
import org.joda.time.DateTime;

import java.util.*;

/**
 * @author zhuzhigang
 */
public class MockStreamxLogAvro {
    private static long getSize(String propertiesName) throws Exception {

        Properties properties = PropertiesUtil.getProperties(propertiesName);
        long logSize = StringUtil.getLong(properties.getProperty("log.size", "5000").trim(), 1);
        return logSize;
    }

    public static String printData(String logTypeName, String timestamp, String source, String offset,
                                   Map<String, String> dimensions, Map<String, Double> metrics, Map<String, String> normalFields) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("logTypeName", logTypeName);
        jsonObject.put("timestamp", timestamp);
        jsonObject.put("source", source);
        jsonObject.put("offset", offset);
        jsonObject.put("dimensions", dimensions);
        jsonObject.put("measures", metrics);
        jsonObject.put("normalFields", normalFields);
        return jsonObject.toString();
    }

    private static String getRandomOffset() {
        Random random = new Random();
        long l = random.nextInt(10000);
        return String.valueOf(l);
    }

    private static Map<String, String> getRandomDimensions() {
        Random random = new Random();
        int i = random.nextInt(10);
        Map<String, String> dimensions = new HashMap<>();

        dimensions.put("hostname", "shandong2");//"zorkdata" + i);
        dimensions.put("ip", "192.168.70.220");
        dimensions.put("appsystem", "dev_test");
        dimensions.put("cluster", "基础监控");
        dimensions.put("module", "ShanDong");
        dimensions.put("servicename", "servicecode");
        dimensions.put("servicecode", "servicecode");
        return dimensions;
    }

    private static String[] codes = {
            "AO", "AF", "AL", "DZ", "AD", "AI", "AG", "AR", "AM", "AU",
            "AT", "AZ", "BS", "BH", "BD", "BB", "BY", "BE", "BZ", "BJ"
    };

    private static String getRandomCountryCode() {
        Random random = new Random(codes.length);
        return codes[new Random(codes.length).nextInt(codes.length)];
    }

    private static Map<String, String> getRandomNormalFieldsError() {
        Map<String, String> normalFields = new HashMap<>();
        normalFields.put("message", "data update error");
//        normalFields.put("countryCode", getRandomCountryCode());
//        normalFields.put("collecttime", "testCollecttime");
        return normalFields;
    }

    private static Map<String, String> getRandomNormalFieldsSuccess() {
        Map<String, String> normalFields = new HashMap<>();
        normalFields.put("message", "data update success");
//        normalFields.put("countryCode", getRandomCountryCode());
//        normalFields.put("collecttime", "testCollecttime");
        return normalFields;
    }

    public static void main(String[] args) throws Exception {
        long size = 30000;
        int cycle = 0;
        DateTime timeNow = new DateTime();
        int minute = timeNow.getSecondOfMinute()/15*15;
        DateTime timeStart = new DateTime(timeNow.getYear(),timeNow.getMonthOfYear(),timeNow.getDayOfMonth(),timeNow.getHourOfDay(), timeNow.getMinuteOfHour(),minute,000);
//        DateTime timeStart = new DateTime(2020,12,02,9, 00,00,000);
        for (int i = 0; i < size; i++) {
            if (i != 0) {
                timeStart = timeStart.plusSeconds(20);
                Thread.sleep(20000);
            }
            DateTime time = new DateTime(new Date());
            String logTypeName = "default_analysis_template";
//            String timestamp = DateUtil.getUTCTimeStr();
            String timestamp = timeStart.toString();
            String source = "/var/log/test.log";
            String offset = getRandomOffset();
            Map<String, String> dimensions = getRandomDimensions();
            Map<String, Double> measures = new HashMap<>();
            Map<String, String> normalFields = null;

//            if (cycle==0) {
//            if (cycle==0||cycle==2||cycle==8||cycle==13) {
                normalFields = getRandomNormalFieldsError();
//                cycle++;
//            }
//            else if (cycle>=8&&cycle<=10) {
//                cycle++;
//                normalFields = getRandomNormalFieldsSuccess();
//            }
//            else {
//                if (cycle == 15) {
//                    cycle = 0;
//                }else {
//                    cycle++;
//                }
//                continue;
//            }
            //System.out.println(printData(logTypeName, timestamp, source, offset, dimensions, measures, normalFields));
            Producer producer = ProducerPool.getInstance().getProducer();
//            producer.sendLog("alert_test_source", logTypeName, timestamp, source, offset, dimensions, measures, normalFields);
            producer.sendLog("dwd_default_log", logTypeName, timestamp, source, offset, dimensions, measures, normalFields);
        }

        Thread.sleep(1000);
    }
}
