package com.zorkdata.tools.mock;

import com.zorkdata.tools.avro.AvroSerializer;
import com.zorkdata.tools.avro.AvroSerializerFactory;
import lombok.extern.slf4j.Slf4j;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.joda.time.DateTime;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

/**
 * @author DeleMing
 */
@Slf4j
public class MockStreamxMetricAvroQQT {
    private static String topic = "qqt_dwd_all_metric";
    //    private static String brokerAddr = "kafka-1:19092,kafka-2:19092,kafka-3:19092";
//    private static String brokerAddr = "yf122:9092,yf121:9092,yf120:9092";
//    private static String brokerAddr = "autotest-3:9092,autotest-2:9092,autotest-1:9092";
    private static String brokerAddr = "node1:9092,node2:9092,node3:9092";
//    private static String brokerAddr = "yf170:9092,yf171:9092,yf172:9092";
//    private static String brokerAddr = "127.0.0.1:9092";
    private static ProducerRecord<String, byte[]> producerRecord = null;
    private static KafkaProducer<String, byte[]> producer = null;
    private static DateTime timeStart;

    public static void init() {
        Properties props = new Properties();
        props.put("bootstrap.servers", brokerAddr);
        props.put("acks", "1");
        props.put("retries", 0);
        props.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        props.put("value.serializer", ByteArraySerializer.class.getName());
        props.put("batch.size", 16384);
        props.put("linger.ms", 1);
        props.put("buffer.memory", 33554432);
        producer = new KafkaProducer<String, byte[]>(props);
    }

    public static byte[] buildMetric(double userPct) {
        String metricSetName = "cpu_system_mb";
//        String timestamp = timeStart.toString();
        String timestamp = String.valueOf(timeStart.getMillis());
        Map<String, String> dimensions = new HashMap<>();

        dimensions.put("hostname", "shandong2");//"zorkdata" + i);
//        dimensions.put("ip", "192.168.70.120");
        dimensions.put("ip", "192.168.70.220");
        dimensions.put("appsystem", "dev_test");
        dimensions.put("cluster", "基础监控");
        dimensions.put("module", "lmt模块");

        Map<String, Double> metrics = new HashMap<>();
        metrics.put("user_pct", userPct);
//        metrics.put("system_pct", userPct);

        AvroSerializer metricSerializer = AvroSerializerFactory.getMetricAvroSerializer();
        byte[] bytes = metricSerializer.serializingMetric(metricSetName, timestamp, dimensions, metrics);
        //qqt
        System.out.println(timestamp+","+userPct);
        return bytes;
    }

    public static void send(String topic, double userPct) {
        byte[] req = buildMetric(userPct);
        producerRecord = new ProducerRecord<String, byte[]>(
                topic,
                "",
                req
        );
        producer.send(producerRecord);
    }

    public static void main(String[] args) throws InterruptedException {
        init();
        DateTime timeNow = new DateTime();
        //时间往前对齐，15s。比如当前时间是21:22:17, 则时间取值为21:22:15
        int minute = timeNow.getSecondOfMinute() / 15 * 15;
        timeStart = new DateTime(timeNow.getYear(), timeNow.getMonthOfYear(), timeNow.getDayOfMonth(), timeNow.getHourOfDay(), timeNow.getMinuteOfHour(), minute, 000);

        System.out.println(timeStart);
        //sin
//        for (int i = 0; i <= 100 ; i++) {
//            for (double y = 0; y < 360; y += 18) {
//                double radians = Math.toRadians(y);
//                send(topic, Math.sin(radians));
//                Thread.sleep(15000);
//                timeStart = timeStart.plusSeconds(15);
//            }
//        }

//        for (int i = 0; i < 1000; i++){
//            int result = fun1(i%4);
//            send(topic,result);
//            Thread.sleep(15000);
//            timeStart = timeStart.plusSeconds(15);
//        }

//        // qqt折现式sin
        for (int i = 0; i < 100 ; i++){
            int result = fun1(i%4);
            send(topic,result);
            Thread.sleep(15000);
            timeStart = timeStart.plusSeconds(15);
        }

//        for (int i = 0; i <= 30000; i++) {
//            if (i != 0) {
//                //15s发一次数据
//                Thread.sleep(15000);
//            }
//        //当时间为0, 2, 8, 13发送，具体的看一下那个测试用例Excel
//            int cycle = i%16;
//            if (cycle==0||cycle==13) {
//                send(topic,1);
//                log.info(timeStart+"=>1");
//            }else if (cycle==2||cycle==8) {
//                send(topic,0.3);
//                log.info(timeStart+"=>0.3");
//            }
//            int cycle = i % 20;
//            if (cycle <= 11) {
//                send(topic, 0.5);
//            }
//
//            timeStart = timeStart.plusSeconds(15);
//        }
    }

    public static int fun1(int i){
        int tmp = 0;
        if (tmp ==0){
            tmp = 0;
        }
        if (i == 1){
            tmp = -1;
        }
        if (i == 2){
            tmp = 0;
        }
        if (i == 3){
            tmp = 1;
        }
        return tmp;
    }


}
