package com.zorkdata.tools.kafka;


import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;

import javax.security.auth.login.Configuration;
import java.util.*;

public class Producer {
//    static String servers = "yf122:9092,yf121:9092,yf120:9092";
    static String servers = "node1:9092,node2:9092,node3:9092";
//    static String servers = "kafka-1:19092,kafka-2:19092,kafka-3:19092";
    static int batchsize = 1;
    static Producer testProducer;
    static String metricTopic;
    static String errorLogTopic;
    static String errorMetricTopic;
    static String alarmTopic;
    static String defaultLogTopic;
    static List<String> cep_change_event_logtypename = new ArrayList<String>();
    static String cep_change_event_topic;
    public static Map<String, String> APPSYSTEM_TOPIC_MAP = new HashMap<String, String>();
    public static Map<String, Map<String, String>> APPSYSTEM_SERVICE_TOPIC_MAP = new HashMap<String, Map<String, String>>();

    static int partition = 6;
    private static KafkaProducer<String, byte[]> producer;
    private static KafkaProducer<String, String> noAvroProducer;

    public Producer() {
        try {
            initConfig();
            Properties props = new Properties();
            props.put("bootstrap.servers", servers);
//            props.put("client.id", "webAPI4LogGather");
            props.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
            props.put("value.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
            props.put("batch.size", batchsize);
            producer = new KafkaProducer<String, byte[]>(props);
            props.put("value.serializer", "org.apache.kafka.common.serialization.StringSerializer");
            noAvroProducer = new KafkaProducer<String, String>(props);
        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void initConfig() throws Exception {
        servers = "node1:9092,node2:9092,node3:9092";
//        servers = "kafka-1:19092,kafka-2:19092,kafka-3:19092";
        batchsize = 100000;
    }



    public void sendLog(String topic, String logTypeName, String timestamp, String source, String offset,
                        Map<String, String> dimensions, Map<String, Double> metrics, Map<String, String> normalFields) {
        try {
            byte[] bytes = AvroSerializerFactory.getLogAvorSerializer().serializingLog(logTypeName, timestamp, source,
                    offset, dimensions, metrics, normalFields);
            producer.send(new ProducerRecord<String, byte[]>(topic, "", bytes));
            System.out.println(new String(bytes));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sendErrorLog(String logJson) {
        try {
            noAvroProducer.send(new ProducerRecord<String, String>(errorLogTopic, null, logJson));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sendErrorMetric(String logJson) {
        try {
            noAvroProducer.send(new ProducerRecord<String, String>(errorMetricTopic, null, logJson));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sendAlarm(String alarmJson) {
        try {
            noAvroProducer.send(new ProducerRecord<String, String>(alarmTopic, null, alarmJson));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sendMetric(String metricSetName, String timestamp, Map<String, String> dimensions,
                           Map<String, Double> metrics) {
        try {
            byte[] bytes = AvroSerializerFactory.getMetricAvorSerializer().serializingMetric(metricSetName, timestamp,
                    dimensions, metrics);
            producer.send(new ProducerRecord<String, byte[]>(metricTopic, "", bytes));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }




}
