package com.zorkdata.tools.mock;

import com.zorkdata.tools.avro.AvroSerializer;
import com.zorkdata.tools.avro.AvroSerializerFactory;
import com.zorkdata.tools.utils.DateUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.joda.time.DateTime;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

/**
 * @author DeleMing
 */
@Slf4j
public class MockStreamxMetricAvro0402 {
    private static String topic = "dwd_all_metric";
    private static String brokerAddr = "node1:9092,node2:9092,node3:9092";
    private static ProducerRecord<String, byte[]> producerRecord = null;
    private static KafkaProducer<String, byte[]> producer = null;
    private static DateTime timeStart;

    public static void init() {
        Properties props = new Properties();
        props.put("bootstrap.servers", brokerAddr);
        props.put("acks", "1");
        props.put("retries", 0);
        props.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        props.put("value.serializer", ByteArraySerializer.class.getName());
        props.put("batch.size", 16384);
        props.put("linger.ms", 1);
        props.put("buffer.memory", 33554432);
        producer = new KafkaProducer<String, byte[]>(props);
    }

    public static byte[] buildMetric(double userPct) {
        String metricSetName = "cpu_system_mb";
        String timestamp = String.valueOf(timeStart.getMillis());
//        String timestamp = DateUtil.getUTCTimeStr();
        Map<String, String> dimensions = new HashMap<>();

        dimensions.put("hostname", "node1");//"zorkdata" + i);
        dimensions.put("ip", "192.168.70.212");
        dimensions.put("appsystem", "dev_test");
        dimensions.put("cluster", "基础监控");
        dimensions.put("module", "ShanDong");

        Map<String, Double> metrics = new HashMap<>();
        metrics.put("user_pct", userPct);

        AvroSerializer metricSerializer = AvroSerializerFactory.getMetricAvroSerializer();
        byte[] bytes = metricSerializer.serializingMetric(metricSetName, timestamp, dimensions, metrics);
        return bytes;
    }

    public static void send(String topic, double userPct) {
        byte[] req = buildMetric(userPct);
        producerRecord = new ProducerRecord<String, byte[]>(topic, "", req);
        producer.send(producerRecord);
    }

    public static void main(String[] args) throws InterruptedException {
        init();
        for (int i = 0; i < 1000 ; i++){
//            int result = fun1(i%4);
            send(topic,0.2);
            Thread.sleep(10000);
        }
    }

    public static double fun1(int i){
        double tmp = 0;
        if ( i ==0){
            tmp = 0.05;
        }
        if (i == 1){
            tmp = 0.2;
        }
        if (i == 2){
            tmp = 0.2;
        }
        return tmp;
    }


}
