package com.zorkdata.tools.mock;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.serialization.StringSerializer;
import com.zorkdata.tools.pojo.MetricEvent;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;

/**
 * @author DeleMing
 */
public class MockMetricEvent {
    private static String topic = "alert_test_source";
    private static String brokerAddr = "kafka-1:19092,kafka-2:19092,kafka-3:19092";
    private static ProducerRecord<String, String> producerRecord = null;
    private static KafkaProducer<String, String> producer = null;

    public static void init() {
        Properties props = new Properties();

        props.put("bootstrap.servers", brokerAddr);
        props.put("acks", "1");
        props.put("retries", 0);
        props.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        props.put("value.serializer", StringSerializer.class.getName());
        props.put("batch.size", 16384);
        props.put("linger.ms", 1);
        props.put("buffer.memory", 33554432);
        producer = new KafkaProducer(props);
    }

    public static String buildMetricEvent() {
//        String name = "cpu_system_mb";
//        Long timestamp = System.currentTimeMillis();
//        Map<String, Object> fields = new HashMap<>();
//        fields.put("used_pct", 0.5);
//        Map<String, String> tags = new HashMap<>();
//        tags.put("hostname", "yf170");
//        MetricEvent metricEvent = new MetricEvent(name, timestamp, fields, tags);


        JSONObject jsonObject = new JSONObject();
        jsonObject.put("id","1");
        jsonObject.put("alarmTime","1608775050000");
        jsonObject.put("state","normal");


        return JSON.toJSONString(jsonObject);
    }


    public static void send() throws ExecutionException, InterruptedException {
        init();
        String req = buildMetricEvent();
        System.out.println(req);
        producerRecord = new ProducerRecord<String, String>(
                topic,
                null,
                req
        );
        producer.send(producerRecord).get();
    }


    public static void main(String[] args) throws ExecutionException, InterruptedException {
        for (int i = 0; i < 3; i++) {
            send();
        }
    }
}
