package com.zorkdata.tools.mock;

import com.alibaba.fastjson.JSONObject;
import com.zorkdata.tools.kafka.Producer;
import com.zorkdata.tools.kafka.ProducerPool;
import com.zorkdata.tools.utils.DateUtil;
import com.zorkdata.tools.utils.PropertiesUtil;
import com.zorkdata.tools.utils.StringUtil;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Random;

/**
 * @author zhuzhigang
 */
public class MockLogNode2 {
    private static long getSize(String propertiesName) throws Exception {

        Properties properties = PropertiesUtil.getProperties(propertiesName);
        long logSize = StringUtil.getLong(properties.getProperty("log.size", "5000").trim(), 1);
        return logSize;
    }

    public static String printData(String logTypeName, String timestamp, String source, String offset,
                                   Map<String, String> dimensions, Map<String, Double> metrics, Map<String, String> normalFields) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("logTypeName", logTypeName);
        jsonObject.put("timestamp", timestamp);
        jsonObject.put("source", source);
        jsonObject.put("offset", offset);
        jsonObject.put("dimensions", dimensions);
        jsonObject.put("measures", metrics);
        jsonObject.put("normalFields", normalFields);
        return jsonObject.toString();
    }

    private static String getRandomOffset() {
        Random random = new Random();
        long l = random.nextInt(10000);
        return String.valueOf(l);
    }

    private static Map<String, String> getRandomDimensions() {
        Random random = new Random();
        int i = random.nextInt(10);
        Map<String, String> dimensions = new HashMap<>();
        dimensions.put("hostname", "node1");//"zorkdata" + i);
        dimensions.put("ip", "192.168.70.212");
        dimensions.put("appsystem", "dev_test");
        dimensions.put("clustername", "基础监控");
        dimensions.put("appprogramname", "ShanDong");
//        dimensions.put("servicename", "linux模块");
//        dimensions.put("servicecode", "linux模块");
//        dimensions.put("appsystem", "dev_test");
//        dimensions.put("clustername", "基础监控");
//        dimensions.put("appprogramname", "linux模块");
//        dimensions.put("hostname", "host-11");
//        dimensions.put("ip", "192.168.13.11");
        return dimensions;
    }

    private static String[] codes = {
            "AO", "AF", "AL", "DZ", "AD", "AI", "AG", "AR", "AM", "AU",
            "AT", "AZ", "BS", "BH", "BD", "BB", "BY", "BE", "BZ", "BJ"
    };

    private static String getRandomCountryCode() {
        Random random = new Random(codes.length);
        return codes[new Random(codes.length).nextInt(codes.length)];
    }

    private static Map<String, String> getRandomNormalFieldsError() {
        Map<String, String> normalFields = new HashMap<>();
        normalFields.put("message", "wwwwaaaaerrorssdddd");
        return normalFields;
    }

    private static Map<String, String> getRandomNormalFieldsSuccess() {
        Map<String, String> normalFields = new HashMap<>();
        normalFields.put("message", "data update success");
        return normalFields;
    }

    public static void main(String[] args) throws Exception {
        long size = 30000;
        for (int i = 0; i < size; i++) {
            if (i != 0) {
                Thread.sleep(5000);
            }
            String logTypeName = "default_analysis_template";
            String timestamp = DateUtil.getUTCTimeStr();
            System.out.println("timestamp====="+timestamp);
            String source = "/var/log/test.log";
            String offset = getRandomOffset();
            Map<String, String> dimensions = getRandomDimensions();
            Map<String, Double> measures = new HashMap<>();
            Map<String, String> normalFields = null;

            normalFields = getRandomNormalFieldsError();
            Producer producer = ProducerPool.getInstance().getProducer();
            producer.sendLog("dwd_default_log", logTypeName, timestamp, source, offset, dimensions, measures, normalFields);
        }

    }
}
