package com.zorkdta.tools.mock;

import com.zorkdta.tools.avro.AvroSerializerFactory;
import lombok.Data;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Map;
import java.util.Properties;

/**
 * @author DeleMing
 */
@Data
public class KafkaProducerUtil {
    private Logger log = LoggerFactory.getLogger(KafkaProducerUtil.class);

    /**
     * kafka相关代码
     */
    private String kafkaBootstrapServers;

    private Integer kafkaBatchSize;

    /**
     * kafka的SASL的验证
     */
    private boolean kafkaSaslFlag;

    private String kafkaSaslAppkey;

    private String kafkaSaslSecretkey;

    private String kafkaSaslMechanism;

    /**
     * kafka的kerberos验证
     */
    private boolean kafkaKerberosFlag;

    private String kafkaKerberosKrb5Conf;

    private String kafkaKerberosJaasConf;

    private String kafkaSecurityProtocol;

    private String kafkaSaslKerberosServiceName;

    private static KafkaProducer<String, byte[]> producer;
    private static KafkaProducer<String, String> noAvroProducer;

    public KafkaProducerUtil(String kafkaBootstrapServers, Integer kafkaBatchSize){
        this.kafkaBootstrapServers = kafkaBootstrapServers;
        this.kafkaBatchSize = kafkaBatchSize;
        this.kafkaSaslFlag = false;
        this.kafkaKerberosFlag = false;
        createKafkaClient();
    }

    public KafkaProducerUtil(String kafkaBootstrapServers, Integer kafkaBatchSize, boolean kafkaSaslFlag, String kafkaSecurityProtocol,
                             String kafkaSaslMechanism, String kafkaSaslAppkey, String kafkaSaslSecretkey){
        this.kafkaBootstrapServers = kafkaBootstrapServers;
        this.kafkaBatchSize = kafkaBatchSize;
        this.kafkaSaslFlag = kafkaSaslFlag;
        this.kafkaKerberosFlag = false;
        this.kafkaSecurityProtocol= kafkaSecurityProtocol;
        this.kafkaSaslMechanism = kafkaSaslMechanism;
        this.kafkaSaslAppkey = kafkaSaslAppkey;
        this.kafkaSaslSecretkey = kafkaSaslSecretkey;
        createKafkaClient();
    }

    public KafkaProducerUtil(String kafkaBootstrapServers, Integer kafkaBatchSize, boolean kafkaKerberosFlag, String kafkaKerberosKrb5Conf,
                             String kafkaKerberosJaasConf, String kafkaSecurityProtocol, String kafkaSaslKerberosServiceName, String kafkaSaslMechanism){
        this.kafkaBootstrapServers = kafkaBootstrapServers;
        this.kafkaBatchSize = kafkaBatchSize;
        this.kafkaSaslFlag = false;
        this.kafkaKerberosFlag = kafkaKerberosFlag;
        this.kafkaSecurityProtocol= kafkaSecurityProtocol;
        this.kafkaSaslMechanism = kafkaSaslMechanism;
        this.kafkaKerberosKrb5Conf = kafkaKerberosKrb5Conf;
        this.kafkaKerberosJaasConf = kafkaKerberosJaasConf;
        this.kafkaSaslKerberosServiceName = kafkaSaslKerberosServiceName;
        createKafkaClient();
    }

    public KafkaProducerUtil(String kafkaBootstrapServers, Integer kafkaBatchSize,boolean kafkaSaslFlag, boolean kafkaKerberosFlag, String kafkaKerberosKrb5Conf,
                             String kafkaKerberosJaasConf, String kafkaSecurityProtocol, String kafkaSaslKerberosServiceName,
                             String kafkaSaslMechanism,  String kafkaSaslAppkey, String kafkaSaslSecretkey){
        this.kafkaBootstrapServers = kafkaBootstrapServers;
        this.kafkaBatchSize = kafkaBatchSize;
        this.kafkaSaslFlag = kafkaSaslFlag;
        this.kafkaKerberosFlag = kafkaKerberosFlag;
        this.kafkaSecurityProtocol= kafkaSecurityProtocol;
        this.kafkaSaslMechanism = kafkaSaslMechanism;
        this.kafkaKerberosKrb5Conf = kafkaKerberosKrb5Conf;
        this.kafkaKerberosJaasConf = kafkaKerberosJaasConf;
        this.kafkaSaslKerberosServiceName = kafkaSaslKerberosServiceName;
        this.kafkaSaslAppkey = kafkaSaslAppkey;
        this.kafkaSaslSecretkey = kafkaSaslSecretkey;
        createKafkaClient();
    }

    public void createKafkaClient() {
        try {
            Properties props = new Properties();
            props.put("bootstrap.servers", kafkaBootstrapServers);
            props.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
            props.put("value.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
            props.put("batch.size", kafkaBatchSize);
            if (kafkaSaslFlag) {
                props.put("security.protocol", kafkaSecurityProtocol);
                props.put("sasl.mechanism", kafkaSaslMechanism);
                //Configuration.setConfiguration(new SaslConfig(kafkaSaslAppkey, kafkaSaslSecretkey));
            }
            if (kafkaKerberosFlag) {
                System.setProperty("java.security.krb5.conf", kafkaKerberosKrb5Conf);
                System.setProperty("java.security.auth.login.config", kafkaKerberosJaasConf);
                props.put("security.protocol", kafkaSecurityProtocol);
                props.put("sasl.kerberos.service.name", kafkaSaslKerberosServiceName);
                props.put("sasl.mechanism", kafkaSaslMechanism);
            }
            producer = new KafkaProducer<String, byte[]>(props);

            props.put("value.serializer", "org.apache.kafka.common.serialization.StringSerializer");
            noAvroProducer = new KafkaProducer<String, String>(props);

        } catch (Exception ex) {
            ex.printStackTrace();
            log.error("初始化Kafka失败,系统自动退出! ", ex);
            System.exit(1);
        }
    }

    public void sendAlarm(String topic, String alarmJson) {
        try {
            noAvroProducer.send(new ProducerRecord<String, String>(topic, null, alarmJson));
        } catch (Exception e) {
            log.error("sendAlarm-插入Kafka失败", e);
        }
    }

    public void sendMetric(String metricSetName, String timestamp, Map<String, String> dimensions,
                           Map<String, Double> metrics, String topic) {
        try {
            byte[] bytes = AvroSerializerFactory.getMetricAvroSerializer().serializingMetric(metricSetName, timestamp,
                    dimensions, metrics);
            producer.send(new ProducerRecord<String, byte[]>(topic, null, bytes));
        } catch (Exception e) {
            log.error("sendMetric-插入Kafka失败", e);
        }
    }

    public void sendLog(String topic, String logTypeName, String timestamp, String source, String offset,
                        Map<String, String> dimensions, Map<String, Double> metrics, Map<String, String> normalFields) {
        try {
            byte[] bytes = AvroSerializerFactory.getLogAvroSerializer().serializingLog(logTypeName, timestamp, source,
                    offset, dimensions, metrics, normalFields);
            producer.send(new ProducerRecord<String, byte[]>(topic, null, bytes));
        } catch (Exception e) {
            log.error("sendLog-插入Kafka失败", e);
        }
    }




}
