package com.zorkdata.tools.mock;

import com.alibaba.fastjson.JSONObject;
import com.zorkdata.tools.avro.AvroSerializer;
import com.zorkdata.tools.avro.AvroSerializerFactory;
import com.zorkdata.tools.kafka.Producer;
import com.zorkdata.tools.kafka.ProducerPool;
import com.zorkdata.tools.utils.PropertiesUtil;
import com.zorkdata.tools.utils.StringUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.joda.time.DateTime;

import java.util.*;

/**
 * @author zhuzhigang
 */
@Slf4j
public class MockStreamxMetricAvroTestRandom {

    private static String topic = "alert_test_source";
    private static String brokerAddr = "yf122:9092,yf121:9092,yf120:9092";
    private static ProducerRecord<String, byte[]> producerRecord = null;
    private static KafkaProducer<String, byte[]> producer = null;

    public static void init() {
        Properties props = new Properties();
        props.put("bootstrap.servers", brokerAddr);
        props.put("acks", "1");
        props.put("retries", 0);
        props.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        props.put("value.serializer", ByteArraySerializer.class.getName());
        props.put("batch.size", 16384);
        props.put("linger.ms", 1);
        props.put("buffer.memory", 33554432);
        producer = new KafkaProducer<String, byte[]>(props);
    }

    public static byte[] buildMetric() {
        Random random = new Random();
        String metricSetName = "cpu_system_mb";
        DateTime timeNow = new DateTime();
        int minute = timeNow.getSecondOfMinute()/15*15;
        DateTime timeStart = new DateTime(timeNow.getYear(),timeNow.getMonthOfYear(),timeNow.getDayOfMonth(),timeNow.getHourOfDay(), timeNow.getMinuteOfHour(),minute,000);

        log.info(timeStart+"=>0.3");

//        String timestamp = timeStart.toString();
        String timestamp = String.valueOf(timeStart.getMillis());
        Map<String, String> dimensions = new HashMap<>();
        dimensions.put("hostname", "yf120");//"zorkdata" + i);
        dimensions.put("ip", "192.168.70.120");
        dimensions.put("appsystem", "dev_test");
        dimensions.put("cluster", "基础监控");
        dimensions.put("module", "lmt模块");

        Map<String, Double> metrics = new HashMap<>();
        metrics.put("user_pct", 0.5);

        AvroSerializer metricSerializer = AvroSerializerFactory.getMetricAvroSerializer();
        byte[] bytes = metricSerializer.serializingMetric(metricSetName, timestamp, dimensions, metrics);
        return bytes;
    }

    public static void send(String topic) {
        byte[] req = buildMetric();
        producerRecord = new ProducerRecord<String, byte[]>(
                topic,
                "",
                req
        );
        producer.send(producerRecord);
    }

    public static void main(String[] args) throws InterruptedException {
        init();
        Random r = new Random();
        for (int i = 0; i <= 300; i++) {
            if (i != 0) {
                int randomNum = r.nextInt(100-20+1)+20;
                Thread.sleep(randomNum*1000);
            }
            send(topic);
        }
    }
}